package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeStreamSummaryResponse(
    streamDescriptionSummary: zio.aws.kinesis.model.StreamDescriptionSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse = {
    import DescribeStreamSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse
      .builder()
      .streamDescriptionSummary(streamDescriptionSummary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamSummaryResponse.wrap(buildAwsValue())
}
object DescribeStreamSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamSummaryResponse =
      zio.aws.kinesis.model
        .DescribeStreamSummaryResponse(streamDescriptionSummary.asEditable)
    def streamDescriptionSummary
        : zio.aws.kinesis.model.StreamDescriptionSummary.ReadOnly
    def getStreamDescriptionSummary: ZIO[
      Any,
      Nothing,
      zio.aws.kinesis.model.StreamDescriptionSummary.ReadOnly
    ] = ZIO.succeed(streamDescriptionSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse
  ) extends zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly {
    override val streamDescriptionSummary
        : zio.aws.kinesis.model.StreamDescriptionSummary.ReadOnly =
      zio.aws.kinesis.model.StreamDescriptionSummary
        .wrap(impl.streamDescriptionSummary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse
  ): zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly = new Wrapper(
    impl
  )
}
