package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.kinesis.model.primitives.{Timestamp, ConsumerARN, ConsumerName}
import scala.jdk.CollectionConverters.*
final case class Consumer(
    consumerName: ConsumerName,
    consumerARN: ConsumerARN,
    consumerStatus: zio.aws.kinesis.model.ConsumerStatus,
    consumerCreationTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.Consumer = {
    import Consumer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.Consumer
      .builder()
      .consumerName(ConsumerName.unwrap(consumerName): java.lang.String)
      .consumerARN(ConsumerARN.unwrap(consumerARN): java.lang.String)
      .consumerStatus(consumerStatus.unwrap)
      .consumerCreationTimestamp(
        Timestamp.unwrap(consumerCreationTimestamp): Instant
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.Consumer.ReadOnly =
    zio.aws.kinesis.model.Consumer.wrap(buildAwsValue())
}
object Consumer {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kinesis.model.Consumer] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.Consumer =
      zio.aws.kinesis.model.Consumer(
        consumerName,
        consumerARN,
        consumerStatus,
        consumerCreationTimestamp
      )
    def consumerName: ConsumerName
    def consumerARN: ConsumerARN
    def consumerStatus: zio.aws.kinesis.model.ConsumerStatus
    def consumerCreationTimestamp: Timestamp
    def getConsumerName: ZIO[Any, Nothing, ConsumerName] =
      ZIO.succeed(consumerName)
    def getConsumerARN: ZIO[Any, Nothing, ConsumerARN] =
      ZIO.succeed(consumerARN)
    def getConsumerStatus
        : ZIO[Any, Nothing, zio.aws.kinesis.model.ConsumerStatus] =
      ZIO.succeed(consumerStatus)
    def getConsumerCreationTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(consumerCreationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.Consumer
  ) extends zio.aws.kinesis.model.Consumer.ReadOnly {
    override val consumerName: ConsumerName =
      zio.aws.kinesis.model.primitives.ConsumerName(impl.consumerName())
    override val consumerARN: ConsumerARN =
      zio.aws.kinesis.model.primitives.ConsumerARN(impl.consumerARN())
    override val consumerStatus: zio.aws.kinesis.model.ConsumerStatus =
      zio.aws.kinesis.model.ConsumerStatus.wrap(impl.consumerStatus())
    override val consumerCreationTimestamp: Timestamp =
      zio.aws.kinesis.model.primitives
        .Timestamp(impl.consumerCreationTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.Consumer
  ): zio.aws.kinesis.model.Consumer.ReadOnly = new Wrapper(impl)
}
