package zio.aws.kinesis
import zio.aws.kinesis.model.primitives.StreamName
import zio.aws.kinesis.model.Shard.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.kinesis.model.{
  DescribeStreamRequest,
  ListStreamsRequest,
  AddTagsToStreamRequest,
  UpdateShardCountRequest,
  ListShardsRequest,
  SplitShardRequest,
  MergeShardsRequest,
  DescribeStreamSummaryRequest,
  PutRecordRequest,
  GetRecordsRequest,
  DescribeLimitsRequest,
  CreateStreamRequest,
  DescribeStreamConsumerRequest,
  EnableEnhancedMonitoringRequest,
  ListStreamConsumersRequest,
  RegisterStreamConsumerRequest,
  DeregisterStreamConsumerRequest,
  DeleteStreamRequest,
  StartStreamEncryptionRequest,
  GetShardIteratorRequest,
  DecreaseStreamRetentionPeriodRequest,
  UpdateStreamModeRequest,
  DisableEnhancedMonitoringRequest,
  ListTagsForStreamRequest,
  IncreaseStreamRetentionPeriodRequest,
  PutRecordsRequest,
  SubscribeToShardRequest,
  StopStreamEncryptionRequest,
  RemoveTagsFromStreamRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient
object KinesisMock extends Mock[Kinesis] {
  object ListShards extends Stream[ListShardsRequest, AwsError, ReadOnly]
  object ListShardsPaginated
      extends Effect[
        ListShardsRequest,
        AwsError,
        zio.aws.kinesis.model.ListShardsResponse.ReadOnly
      ]
  object DescribeStreamConsumer
      extends Effect[
        DescribeStreamConsumerRequest,
        AwsError,
        zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly
      ]
  object ListStreams extends Stream[ListStreamsRequest, AwsError, StreamName]
  object ListStreamsPaginated
      extends Effect[
        ListStreamsRequest,
        AwsError,
        zio.aws.kinesis.model.ListStreamsResponse.ReadOnly
      ]
  object SplitShard extends Effect[SplitShardRequest, AwsError, Unit]
  object PutRecord
      extends Effect[
        PutRecordRequest,
        AwsError,
        zio.aws.kinesis.model.PutRecordResponse.ReadOnly
      ]
  object UpdateShardCount
      extends Effect[
        UpdateShardCountRequest,
        AwsError,
        zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly
      ]
  object DisableEnhancedMonitoring
      extends Effect[
        DisableEnhancedMonitoringRequest,
        AwsError,
        zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly
      ]
  object StartStreamEncryption
      extends Effect[StartStreamEncryptionRequest, AwsError, Unit]
  object DeregisterStreamConsumer
      extends Effect[DeregisterStreamConsumerRequest, AwsError, Unit]
  object RemoveTagsFromStream
      extends Effect[RemoveTagsFromStreamRequest, AwsError, Unit]
  object StopStreamEncryption
      extends Effect[StopStreamEncryptionRequest, AwsError, Unit]
  object PutRecords
      extends Effect[
        PutRecordsRequest,
        AwsError,
        zio.aws.kinesis.model.PutRecordsResponse.ReadOnly
      ]
  object GetShardIterator
      extends Effect[
        GetShardIteratorRequest,
        AwsError,
        zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly
      ]
  object DeleteStream extends Effect[DeleteStreamRequest, AwsError, Unit]
  object UpdateStreamMode
      extends Effect[UpdateStreamModeRequest, AwsError, Unit]
  object DescribeStream
      extends Effect[
        DescribeStreamRequest,
        AwsError,
        zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly
      ]
  object EnableEnhancedMonitoring
      extends Effect[
        EnableEnhancedMonitoringRequest,
        AwsError,
        zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly
      ]
  object CreateStream extends Effect[CreateStreamRequest, AwsError, Unit]
  object DecreaseStreamRetentionPeriod
      extends Effect[DecreaseStreamRetentionPeriodRequest, AwsError, Unit]
  object ListStreamConsumers
      extends Stream[
        ListStreamConsumersRequest,
        AwsError,
        zio.aws.kinesis.model.Consumer.ReadOnly
      ]
  object ListStreamConsumersPaginated
      extends Effect[
        ListStreamConsumersRequest,
        AwsError,
        zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly
      ]
  object AddTagsToStream extends Effect[AddTagsToStreamRequest, AwsError, Unit]
  object MergeShards extends Effect[MergeShardsRequest, AwsError, Unit]
  object DescribeStreamSummary
      extends Effect[
        DescribeStreamSummaryRequest,
        AwsError,
        zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly
      ]
  object RegisterStreamConsumer
      extends Effect[
        RegisterStreamConsumerRequest,
        AwsError,
        zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly
      ]
  object DescribeLimits
      extends Effect[
        DescribeLimitsRequest,
        AwsError,
        zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly
      ]
  object IncreaseStreamRetentionPeriod
      extends Effect[IncreaseStreamRetentionPeriodRequest, AwsError, Unit]
  object SubscribeToShard
      extends Stream[
        SubscribeToShardRequest,
        AwsError,
        zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly
      ]
  object GetRecords
      extends Effect[
        GetRecordsRequest,
        AwsError,
        zio.aws.kinesis.model.GetRecordsResponse.ReadOnly
      ]
  object ListTagsForStream
      extends Effect[
        ListTagsForStreamRequest,
        AwsError,
        zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Kinesis] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Kinesis] { rts =>
        zio.ZIO.succeed {
          new Kinesis {
            val api: KinesisAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Kinesis = this
            def listShards(
                request: ListShardsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListShards, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listShardsPaginated(
                request: ListShardsRequest
            ): IO[AwsError, zio.aws.kinesis.model.ListShardsResponse.ReadOnly] =
              proxy(ListShardsPaginated, request)
            def describeStreamConsumer(
                request: DescribeStreamConsumerRequest
            ): IO[
              AwsError,
              zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly
            ] = proxy(DescribeStreamConsumer, request)
            def listStreams(
                request: ListStreamsRequest
            ): ZStream[Any, AwsError, StreamName] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListStreams, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listStreamsPaginated(request: ListStreamsRequest): IO[
              AwsError,
              zio.aws.kinesis.model.ListStreamsResponse.ReadOnly
            ] = proxy(ListStreamsPaginated, request)
            def splitShard(request: SplitShardRequest): IO[AwsError, Unit] =
              proxy(SplitShard, request)
            def putRecord(
                request: PutRecordRequest
            ): IO[AwsError, zio.aws.kinesis.model.PutRecordResponse.ReadOnly] =
              proxy(PutRecord, request)
            def updateShardCount(request: UpdateShardCountRequest): IO[
              AwsError,
              zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly
            ] = proxy(UpdateShardCount, request)
            def disableEnhancedMonitoring(
                request: DisableEnhancedMonitoringRequest
            ): IO[
              AwsError,
              zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly
            ] = proxy(DisableEnhancedMonitoring, request)
            def startStreamEncryption(
                request: StartStreamEncryptionRequest
            ): IO[AwsError, Unit] = proxy(StartStreamEncryption, request)
            def deregisterStreamConsumer(
                request: DeregisterStreamConsumerRequest
            ): IO[AwsError, Unit] = proxy(DeregisterStreamConsumer, request)
            def removeTagsFromStream(
                request: RemoveTagsFromStreamRequest
            ): IO[AwsError, Unit] = proxy(RemoveTagsFromStream, request)
            def stopStreamEncryption(
                request: StopStreamEncryptionRequest
            ): IO[AwsError, Unit] = proxy(StopStreamEncryption, request)
            def putRecords(
                request: PutRecordsRequest
            ): IO[AwsError, zio.aws.kinesis.model.PutRecordsResponse.ReadOnly] =
              proxy(PutRecords, request)
            def getShardIterator(request: GetShardIteratorRequest): IO[
              AwsError,
              zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly
            ] = proxy(GetShardIterator, request)
            def deleteStream(request: DeleteStreamRequest): IO[AwsError, Unit] =
              proxy(DeleteStream, request)
            def updateStreamMode(
                request: UpdateStreamModeRequest
            ): IO[AwsError, Unit] = proxy(UpdateStreamMode, request)
            def describeStream(request: DescribeStreamRequest): IO[
              AwsError,
              zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly
            ] = proxy(DescribeStream, request)
            def enableEnhancedMonitoring(
                request: EnableEnhancedMonitoringRequest
            ): IO[
              AwsError,
              zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly
            ] = proxy(EnableEnhancedMonitoring, request)
            def createStream(request: CreateStreamRequest): IO[AwsError, Unit] =
              proxy(CreateStream, request)
            def decreaseStreamRetentionPeriod(
                request: DecreaseStreamRetentionPeriodRequest
            ): IO[AwsError, Unit] =
              proxy(DecreaseStreamRetentionPeriod, request)
            def listStreamConsumers(
                request: ListStreamConsumersRequest
            ): ZStream[Any, AwsError, zio.aws.kinesis.model.Consumer.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListStreamConsumers, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listStreamConsumersPaginated(
                request: ListStreamConsumersRequest
            ): IO[
              AwsError,
              zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly
            ] = proxy(ListStreamConsumersPaginated, request)
            def addTagsToStream(
                request: AddTagsToStreamRequest
            ): IO[AwsError, Unit] = proxy(AddTagsToStream, request)
            def mergeShards(request: MergeShardsRequest): IO[AwsError, Unit] =
              proxy(MergeShards, request)
            def describeStreamSummary(
                request: DescribeStreamSummaryRequest
            ): IO[
              AwsError,
              zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly
            ] = proxy(DescribeStreamSummary, request)
            def registerStreamConsumer(
                request: RegisterStreamConsumerRequest
            ): IO[
              AwsError,
              zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly
            ] = proxy(RegisterStreamConsumer, request)
            def describeLimits(request: DescribeLimitsRequest): IO[
              AwsError,
              zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly
            ] = proxy(DescribeLimits, request)
            def increaseStreamRetentionPeriod(
                request: IncreaseStreamRetentionPeriodRequest
            ): IO[AwsError, Unit] =
              proxy(IncreaseStreamRetentionPeriod, request)
            def subscribeToShard(request: SubscribeToShardRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(SubscribeToShard, request)
                }
                .getOrThrowFiberFailure()
            }
            def getRecords(
                request: GetRecordsRequest
            ): IO[AwsError, zio.aws.kinesis.model.GetRecordsResponse.ReadOnly] =
              proxy(GetRecords, request)
            def listTagsForStream(request: ListTagsForStreamRequest): IO[
              AwsError,
              zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly
            ] = proxy(ListTagsForStream, request)
          }
        }
      }
    }
  }
}
