package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  PositiveIntegerObject,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateShardCountRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    targetShardCount: PositiveIntegerObject,
    scalingType: zio.aws.kinesis.model.ScalingType,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest = {
    import UpdateShardCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .targetShardCount(PositiveIntegerObject.unwrap(targetShardCount): Integer)
      .scalingType(scalingType.unwrap)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.UpdateShardCountRequest.ReadOnly =
    zio.aws.kinesis.model.UpdateShardCountRequest.wrap(buildAwsValue())
}
object UpdateShardCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.UpdateShardCountRequest =
      zio.aws.kinesis.model.UpdateShardCountRequest(
        streamName.map(value => value),
        targetShardCount,
        scalingType,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def targetShardCount: PositiveIntegerObject
    def scalingType: zio.aws.kinesis.model.ScalingType
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getTargetShardCount: ZIO[Any, Nothing, PositiveIntegerObject] =
      ZIO.succeed(targetShardCount)
    def getScalingType: ZIO[Any, Nothing, zio.aws.kinesis.model.ScalingType] =
      ZIO.succeed(scalingType)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
  ) extends zio.aws.kinesis.model.UpdateShardCountRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val targetShardCount: PositiveIntegerObject =
      zio.aws.kinesis.model.primitives
        .PositiveIntegerObject(impl.targetShardCount())
    override val scalingType: zio.aws.kinesis.model.ScalingType =
      zio.aws.kinesis.model.ScalingType.wrap(impl.scalingType())
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
  ): zio.aws.kinesis.model.UpdateShardCountRequest.ReadOnly = new Wrapper(impl)
}
