package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{Timestamp, StreamARN, StreamName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class StreamSummary(
    streamName: StreamName,
    streamARN: StreamARN,
    streamStatus: zio.aws.kinesis.model.StreamStatus,
    streamModeDetails: Optional[zio.aws.kinesis.model.StreamModeDetails] =
      Optional.Absent,
    streamCreationTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StreamSummary = {
    import StreamSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StreamSummary
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .streamARN(StreamARN.unwrap(streamARN): java.lang.String)
      .streamStatus(streamStatus.unwrap)
      .optionallyWith(streamModeDetails.map(value => value.buildAwsValue()))(
        _.streamModeDetails
      )
      .optionallyWith(
        streamCreationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.streamCreationTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StreamSummary.ReadOnly =
    zio.aws.kinesis.model.StreamSummary.wrap(buildAwsValue())
}
object StreamSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StreamSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StreamSummary =
      zio.aws.kinesis.model.StreamSummary(
        streamName,
        streamARN,
        streamStatus,
        streamModeDetails.map(value => value.asEditable),
        streamCreationTimestamp.map(value => value)
      )
    def streamName: StreamName
    def streamARN: StreamARN
    def streamStatus: zio.aws.kinesis.model.StreamStatus
    def streamModeDetails
        : Optional[zio.aws.kinesis.model.StreamModeDetails.ReadOnly]
    def streamCreationTimestamp: Optional[Timestamp]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getStreamARN: ZIO[Any, Nothing, StreamARN] = ZIO.succeed(streamARN)
    def getStreamStatus: ZIO[Any, Nothing, zio.aws.kinesis.model.StreamStatus] =
      ZIO.succeed(streamStatus)
    def getStreamModeDetails
        : ZIO[Any, AwsError, zio.aws.kinesis.model.StreamModeDetails.ReadOnly] =
      AwsError.unwrapOptionField("streamModeDetails", streamModeDetails)
    def getStreamCreationTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("streamCreationTimestamp", streamCreationTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StreamSummary
  ) extends zio.aws.kinesis.model.StreamSummary.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val streamARN: StreamARN =
      zio.aws.kinesis.model.primitives.StreamARN(impl.streamARN())
    override val streamStatus: zio.aws.kinesis.model.StreamStatus =
      zio.aws.kinesis.model.StreamStatus.wrap(impl.streamStatus())
    override val streamModeDetails
        : Optional[zio.aws.kinesis.model.StreamModeDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamModeDetails())
        .map(value => zio.aws.kinesis.model.StreamModeDetails.wrap(value))
    override val streamCreationTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamCreationTimestamp())
        .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StreamSummary
  ): zio.aws.kinesis.model.StreamSummary.ReadOnly = new Wrapper(impl)
}
