package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.SequenceNumber
import scala.jdk.CollectionConverters.*
final case class SequenceNumberRange(
    startingSequenceNumber: SequenceNumber,
    endingSequenceNumber: Optional[SequenceNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.SequenceNumberRange = {
    import SequenceNumberRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.SequenceNumberRange
      .builder()
      .startingSequenceNumber(
        SequenceNumber.unwrap(startingSequenceNumber): java.lang.String
      )
      .optionallyWith(
        endingSequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.endingSequenceNumber)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.SequenceNumberRange.ReadOnly =
    zio.aws.kinesis.model.SequenceNumberRange.wrap(buildAwsValue())
}
object SequenceNumberRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.SequenceNumberRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.SequenceNumberRange =
      zio.aws.kinesis.model.SequenceNumberRange(
        startingSequenceNumber,
        endingSequenceNumber.map(value => value)
      )
    def startingSequenceNumber: SequenceNumber
    def endingSequenceNumber: Optional[SequenceNumber]
    def getStartingSequenceNumber: ZIO[Any, Nothing, SequenceNumber] =
      ZIO.succeed(startingSequenceNumber)
    def getEndingSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("endingSequenceNumber", endingSequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.SequenceNumberRange
  ) extends zio.aws.kinesis.model.SequenceNumberRange.ReadOnly {
    override val startingSequenceNumber: SequenceNumber =
      zio.aws.kinesis.model.primitives
        .SequenceNumber(impl.startingSequenceNumber())
    override val endingSequenceNumber: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endingSequenceNumber())
        .map(value => zio.aws.kinesis.model.primitives.SequenceNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.SequenceNumberRange
  ): zio.aws.kinesis.model.SequenceNumberRange.ReadOnly = new Wrapper(impl)
}
