package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  ListTagsForStreamInputLimit,
  TagKey,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTagsForStreamRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    exclusiveStartTagKey: Optional[TagKey] = Optional.Absent,
    limit: Optional[ListTagsForStreamInputLimit] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest = {
    import ListTagsForStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        exclusiveStartTagKey.map(value =>
          TagKey.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartTagKey)
      .optionallyWith(
        limit.map(value => ListTagsForStreamInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly =
    zio.aws.kinesis.model.ListTagsForStreamRequest.wrap(buildAwsValue())
}
object ListTagsForStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListTagsForStreamRequest =
      zio.aws.kinesis.model.ListTagsForStreamRequest(
        streamName.map(value => value),
        exclusiveStartTagKey.map(value => value),
        limit.map(value => value),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def exclusiveStartTagKey: Optional[TagKey]
    def limit: Optional[ListTagsForStreamInputLimit]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getExclusiveStartTagKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("exclusiveStartTagKey", exclusiveStartTagKey)
    def getLimit: ZIO[Any, AwsError, ListTagsForStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ) extends zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val exclusiveStartTagKey: Optional[TagKey] = zio.aws.core.internal
      .optionalFromNullable(impl.exclusiveStartTagKey())
      .map(value => zio.aws.kinesis.model.primitives.TagKey(value))
    override val limit: Optional[ListTagsForStreamInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.kinesis.model.primitives.ListTagsForStreamInputLimit(value)
        )
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ): zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly = new Wrapper(impl)
}
