package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{NextToken, BooleanObject, StreamName}
import scala.jdk.CollectionConverters.*
final case class ListStreamsResponse(
    streamNames: Iterable[StreamName],
    hasMoreStreams: BooleanObject,
    nextToken: Optional[NextToken] = Optional.Absent,
    streamSummaries: Optional[Iterable[zio.aws.kinesis.model.StreamSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamsResponse = {
    import ListStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
      .builder()
      .streamNames(streamNames.map { item =>
        StreamName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .hasMoreStreams(hasMoreStreams: java.lang.Boolean)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        streamSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamSummaries)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamsResponse.ReadOnly =
    zio.aws.kinesis.model.ListStreamsResponse.wrap(buildAwsValue())
}
object ListStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamsResponse =
      zio.aws.kinesis.model.ListStreamsResponse(
        streamNames,
        hasMoreStreams,
        nextToken.map(value => value),
        streamSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def streamNames: List[StreamName]
    def hasMoreStreams: BooleanObject
    def nextToken: Optional[NextToken]
    def streamSummaries
        : Optional[List[zio.aws.kinesis.model.StreamSummary.ReadOnly]]
    def getStreamNames: ZIO[Any, Nothing, List[StreamName]] =
      ZIO.succeed(streamNames)
    def getHasMoreStreams: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreStreams)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStreamSummaries: ZIO[Any, AwsError, List[
      zio.aws.kinesis.model.StreamSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("streamSummaries", streamSummaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
  ) extends zio.aws.kinesis.model.ListStreamsResponse.ReadOnly {
    override val streamNames: List[StreamName] = impl
      .streamNames()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.primitives.StreamName(item)
      }
      .toList
    override val hasMoreStreams: BooleanObject =
      impl.hasMoreStreams(): BooleanObject
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
    override val streamSummaries
        : Optional[List[zio.aws.kinesis.model.StreamSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.StreamSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsResponse
  ): zio.aws.kinesis.model.ListStreamsResponse.ReadOnly = new Wrapper(impl)
}
