package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  RetentionPeriodHours,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class IncreaseStreamRetentionPeriodRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    retentionPeriodHours: RetentionPeriodHours,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest = {
    import IncreaseStreamRetentionPeriodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .retentionPeriodHours(
        RetentionPeriodHours.unwrap(retentionPeriodHours): Integer
      )
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest.ReadOnly =
    zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest
      .wrap(buildAwsValue())
}
object IncreaseStreamRetentionPeriodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest =
      zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest(
        streamName.map(value => value),
        retentionPeriodHours,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def retentionPeriodHours: RetentionPeriodHours
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getRetentionPeriodHours: ZIO[Any, Nothing, RetentionPeriodHours] =
      ZIO.succeed(retentionPeriodHours)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ) extends zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val retentionPeriodHours: RetentionPeriodHours =
      zio.aws.kinesis.model.primitives
        .RetentionPeriodHours(impl.retentionPeriodHours())
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ): zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest.ReadOnly =
    new Wrapper(impl)
}
