package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, StreamName}
import scala.jdk.CollectionConverters.*
final case class EnableEnhancedMonitoringRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    shardLevelMetrics: Iterable[zio.aws.kinesis.model.MetricsName],
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest = {
    import EnableEnhancedMonitoringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .shardLevelMetricsWithStrings(shardLevelMetrics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.EnableEnhancedMonitoringRequest.ReadOnly =
    zio.aws.kinesis.model.EnableEnhancedMonitoringRequest.wrap(buildAwsValue())
}
object EnableEnhancedMonitoringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.EnableEnhancedMonitoringRequest =
      zio.aws.kinesis.model.EnableEnhancedMonitoringRequest(
        streamName.map(value => value),
        shardLevelMetrics,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def shardLevelMetrics: List[zio.aws.kinesis.model.MetricsName]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getShardLevelMetrics
        : ZIO[Any, Nothing, List[zio.aws.kinesis.model.MetricsName]] =
      ZIO.succeed(shardLevelMetrics)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest
  ) extends zio.aws.kinesis.model.EnableEnhancedMonitoringRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val shardLevelMetrics: List[zio.aws.kinesis.model.MetricsName] =
      impl
        .shardLevelMetrics()
        .asScala
        .map { item =>
          zio.aws.kinesis.model.MetricsName.wrap(item)
        }
        .toList
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest
  ): zio.aws.kinesis.model.EnableEnhancedMonitoringRequest.ReadOnly =
    new Wrapper(impl)
}
