package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, StreamName}
import scala.jdk.CollectionConverters.*
final case class DescribeStreamSummaryRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest = {
    import DescribeStreamSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamSummaryRequest.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamSummaryRequest.wrap(buildAwsValue())
}
object DescribeStreamSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamSummaryRequest =
      zio.aws.kinesis.model.DescribeStreamSummaryRequest(
        streamName.map(value => value),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
  ) extends zio.aws.kinesis.model.DescribeStreamSummaryRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
  ): zio.aws.kinesis.model.DescribeStreamSummaryRequest.ReadOnly = new Wrapper(
    impl
  )
}
