package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  ShardId,
  DescribeStreamInputLimit,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeStreamRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    limit: Optional[DescribeStreamInputLimit] = Optional.Absent,
    exclusiveStartShardId: Optional[ShardId] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest = {
    import DescribeStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        limit.map(value => DescribeStreamInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartShardId)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamRequest.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamRequest.wrap(buildAwsValue())
}
object DescribeStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamRequest =
      zio.aws.kinesis.model.DescribeStreamRequest(
        streamName.map(value => value),
        limit.map(value => value),
        exclusiveStartShardId.map(value => value),
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def limit: Optional[DescribeStreamInputLimit]
    def exclusiveStartShardId: Optional[ShardId]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getLimit: ZIO[Any, AwsError, DescribeStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("exclusiveStartShardId", exclusiveStartShardId)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
  ) extends zio.aws.kinesis.model.DescribeStreamRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val limit: Optional[DescribeStreamInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.kinesis.model.primitives.DescribeStreamInputLimit(value)
        )
    override val exclusiveStartShardId: Optional[ShardId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartShardId())
        .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
  ): zio.aws.kinesis.model.DescribeStreamRequest.ReadOnly = new Wrapper(impl)
}
