package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  RetentionPeriodHours,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DecreaseStreamRetentionPeriodRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    retentionPeriodHours: RetentionPeriodHours,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest = {
    import DecreaseStreamRetentionPeriodRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .retentionPeriodHours(
        RetentionPeriodHours.unwrap(retentionPeriodHours): Integer
      )
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest.ReadOnly =
    zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest
      .wrap(buildAwsValue())
}
object DecreaseStreamRetentionPeriodRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest =
      zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest(
        streamName.map(value => value),
        retentionPeriodHours,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def retentionPeriodHours: RetentionPeriodHours
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getRetentionPeriodHours: ZIO[Any, Nothing, RetentionPeriodHours] =
      ZIO.succeed(retentionPeriodHours)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ) extends zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val retentionPeriodHours: RetentionPeriodHours =
      zio.aws.kinesis.model.primitives
        .RetentionPeriodHours(impl.retentionPeriodHours())
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ): zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest.ReadOnly =
    new Wrapper(impl)
}
