package zio.aws.kinesis.model
import scala.jdk.CollectionConverters.*
sealed trait StreamMode {
  def unwrap: software.amazon.awssdk.services.kinesis.model.StreamMode
}
object StreamMode {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.StreamMode
  ): zio.aws.kinesis.model.StreamMode = value match {
    case software.amazon.awssdk.services.kinesis.model.StreamMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.StreamMode.PROVISIONED =>
      val r = PROVISIONED
      r
    case software.amazon.awssdk.services.kinesis.model.StreamMode.ON_DEMAND =>
      val r = ON_DEMAND
      r
  }
  case object unknownToSdkVersion extends zio.aws.kinesis.model.StreamMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamMode =
      software.amazon.awssdk.services.kinesis.model.StreamMode.UNKNOWN_TO_SDK_VERSION
  }
  case object PROVISIONED extends zio.aws.kinesis.model.StreamMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamMode =
      software.amazon.awssdk.services.kinesis.model.StreamMode.PROVISIONED
  }
  case object ON_DEMAND extends zio.aws.kinesis.model.StreamMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.StreamMode =
      software.amazon.awssdk.services.kinesis.model.StreamMode.ON_DEMAND
  }
}
