package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, KeyId, StreamName}
import scala.jdk.CollectionConverters.*
final case class StartStreamEncryptionRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    encryptionType: zio.aws.kinesis.model.EncryptionType,
    keyId: KeyId,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest = {
    import StartStreamEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .encryptionType(encryptionType.unwrap)
      .keyId(KeyId.unwrap(keyId): java.lang.String)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StartStreamEncryptionRequest.ReadOnly =
    zio.aws.kinesis.model.StartStreamEncryptionRequest.wrap(buildAwsValue())
}
object StartStreamEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StartStreamEncryptionRequest =
      zio.aws.kinesis.model.StartStreamEncryptionRequest(
        streamName.map(value => value),
        encryptionType,
        keyId,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def encryptionType: zio.aws.kinesis.model.EncryptionType
    def keyId: KeyId
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.kinesis.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKeyId: ZIO[Any, Nothing, KeyId] = ZIO.succeed(keyId)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
  ) extends zio.aws.kinesis.model.StartStreamEncryptionRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val encryptionType: zio.aws.kinesis.model.EncryptionType =
      zio.aws.kinesis.model.EncryptionType.wrap(impl.encryptionType())
    override val keyId: KeyId =
      zio.aws.kinesis.model.primitives.KeyId(impl.keyId())
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest
  ): zio.aws.kinesis.model.StartStreamEncryptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
