package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, StreamName}
import scala.jdk.CollectionConverters.*
final case class PutRecordsRequest(
    records: Iterable[zio.aws.kinesis.model.PutRecordsRequestEntry],
    streamName: Optional[StreamName] = Optional.Absent,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordsRequest = {
    import PutRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
      .builder()
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordsRequest.ReadOnly =
    zio.aws.kinesis.model.PutRecordsRequest.wrap(buildAwsValue())
}
object PutRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordsRequest =
      zio.aws.kinesis.model.PutRecordsRequest(
        records.map { item =>
          item.asEditable
        },
        streamName.map(value => value),
        streamARN.map(value => value)
      )
    def records: List[zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly]
    def streamName: Optional[StreamName]
    def streamARN: Optional[StreamARN]
    def getRecords: ZIO[Any, Nothing, List[
      zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly
    ]] = ZIO.succeed(records)
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
  ) extends zio.aws.kinesis.model.PutRecordsRequest.ReadOnly {
    override val records
        : List[zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.PutRecordsRequestEntry.wrap(item)
      }
      .toList
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
  ): zio.aws.kinesis.model.PutRecordsRequest.ReadOnly = new Wrapper(impl)
}
