package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{StreamARN, ShardId, StreamName}
import scala.jdk.CollectionConverters.*
final case class MergeShardsRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    shardToMerge: ShardId,
    adjacentShardToMerge: ShardId,
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.MergeShardsRequest = {
    import MergeShardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .shardToMerge(ShardId.unwrap(shardToMerge): java.lang.String)
      .adjacentShardToMerge(
        ShardId.unwrap(adjacentShardToMerge): java.lang.String
      )
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.MergeShardsRequest.ReadOnly =
    zio.aws.kinesis.model.MergeShardsRequest.wrap(buildAwsValue())
}
object MergeShardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.MergeShardsRequest =
      zio.aws.kinesis.model.MergeShardsRequest(
        streamName.map(value => value),
        shardToMerge,
        adjacentShardToMerge,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def shardToMerge: ShardId
    def adjacentShardToMerge: ShardId
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getShardToMerge: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardToMerge)
    def getAdjacentShardToMerge: ZIO[Any, Nothing, ShardId] =
      ZIO.succeed(adjacentShardToMerge)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
  ) extends zio.aws.kinesis.model.MergeShardsRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val shardToMerge: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardToMerge())
    override val adjacentShardToMerge: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.adjacentShardToMerge())
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
  ): zio.aws.kinesis.model.MergeShardsRequest.ReadOnly = new Wrapper(impl)
}
