package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EnhancedMetrics(
    shardLevelMetrics: Optional[Iterable[zio.aws.kinesis.model.MetricsName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.EnhancedMetrics = {
    import EnhancedMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.EnhancedMetrics
      .builder()
      .optionallyWith(
        shardLevelMetrics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.shardLevelMetricsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.EnhancedMetrics.ReadOnly =
    zio.aws.kinesis.model.EnhancedMetrics.wrap(buildAwsValue())
}
object EnhancedMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.EnhancedMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.EnhancedMetrics =
      zio.aws.kinesis.model
        .EnhancedMetrics(shardLevelMetrics.map(value => value))
    def shardLevelMetrics: Optional[List[zio.aws.kinesis.model.MetricsName]]
    def getShardLevelMetrics
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.MetricsName]] =
      AwsError.unwrapOptionField("shardLevelMetrics", shardLevelMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.EnhancedMetrics
  ) extends zio.aws.kinesis.model.EnhancedMetrics.ReadOnly {
    override val shardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shardLevelMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.MetricsName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.EnhancedMetrics
  ): zio.aws.kinesis.model.EnhancedMetrics.ReadOnly = new Wrapper(impl)
}
