package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  TagValue,
  TagKey,
  StreamName
}
import scala.jdk.CollectionConverters.*
final case class AddTagsToStreamRequest(
    streamName: Optional[StreamName] = Optional.Absent,
    tags: Map[TagKey, TagValue],
    streamARN: Optional[StreamARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest = {
    import AddTagsToStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        streamARN.map(value => StreamARN.unwrap(value): java.lang.String)
      )(_.streamARN)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.AddTagsToStreamRequest.ReadOnly =
    zio.aws.kinesis.model.AddTagsToStreamRequest.wrap(buildAwsValue())
}
object AddTagsToStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.AddTagsToStreamRequest =
      zio.aws.kinesis.model.AddTagsToStreamRequest(
        streamName.map(value => value),
        tags,
        streamARN.map(value => value)
      )
    def streamName: Optional[StreamName]
    def tags: Map[TagKey, TagValue]
    def streamARN: Optional[StreamARN]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
    def getStreamARN: ZIO[Any, AwsError, StreamARN] =
      AwsError.unwrapOptionField("streamARN", streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
  ) extends zio.aws.kinesis.model.AddTagsToStreamRequest.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.kinesis.model.primitives
          .TagKey(key) -> zio.aws.kinesis.model.primitives.TagValue(value)
      })
      .toMap
    override val streamARN: Optional[StreamARN] = zio.aws.core.internal
      .optionalFromNullable(impl.streamARN())
      .map(value => zio.aws.kinesis.model.primitives.StreamARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest
  ): zio.aws.kinesis.model.AddTagsToStreamRequest.ReadOnly = new Wrapper(impl)
}
