package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{ShardId, ConsumerARN}
import scala.jdk.CollectionConverters.*
final case class SubscribeToShardRequest(
    consumerARN: ConsumerARN,
    shardId: ShardId,
    startingPosition: zio.aws.kinesis.model.StartingPosition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest = {
    import SubscribeToShardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest
      .builder()
      .consumerARN(ConsumerARN.unwrap(consumerARN): java.lang.String)
      .shardId(ShardId.unwrap(shardId): java.lang.String)
      .startingPosition(startingPosition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.SubscribeToShardRequest.ReadOnly =
    zio.aws.kinesis.model.SubscribeToShardRequest.wrap(buildAwsValue())
}
object SubscribeToShardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.SubscribeToShardRequest =
      zio.aws.kinesis.model.SubscribeToShardRequest(
        consumerARN,
        shardId,
        startingPosition.asEditable
      )
    def consumerARN: ConsumerARN
    def shardId: ShardId
    def startingPosition: zio.aws.kinesis.model.StartingPosition.ReadOnly
    def getConsumerARN: ZIO[Any, Nothing, ConsumerARN] =
      ZIO.succeed(consumerARN)
    def getShardId: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardId)
    def getStartingPosition
        : ZIO[Any, Nothing, zio.aws.kinesis.model.StartingPosition.ReadOnly] =
      ZIO.succeed(startingPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest
  ) extends zio.aws.kinesis.model.SubscribeToShardRequest.ReadOnly {
    override val consumerARN: ConsumerARN =
      zio.aws.kinesis.model.primitives.ConsumerARN(impl.consumerARN())
    override val shardId: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardId())
    override val startingPosition
        : zio.aws.kinesis.model.StartingPosition.ReadOnly =
      zio.aws.kinesis.model.StartingPosition.wrap(impl.startingPosition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.SubscribeToShardRequest
  ): zio.aws.kinesis.model.SubscribeToShardRequest.ReadOnly = new Wrapper(impl)
}
