package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{
  OnDemandStreamCountLimitObject,
  OnDemandStreamCountObject,
  ShardCountObject
}
import scala.jdk.CollectionConverters.*
final case class DescribeLimitsResponse(
    shardLimit: ShardCountObject,
    openShardCount: ShardCountObject,
    onDemandStreamCount: OnDemandStreamCountObject,
    onDemandStreamCountLimit: OnDemandStreamCountLimitObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse = {
    import DescribeLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse
      .builder()
      .shardLimit(ShardCountObject.unwrap(shardLimit): Integer)
      .openShardCount(ShardCountObject.unwrap(openShardCount): Integer)
      .onDemandStreamCount(
        OnDemandStreamCountObject.unwrap(onDemandStreamCount): Integer
      )
      .onDemandStreamCountLimit(
        OnDemandStreamCountLimitObject.unwrap(onDemandStreamCountLimit): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly =
    zio.aws.kinesis.model.DescribeLimitsResponse.wrap(buildAwsValue())
}
object DescribeLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeLimitsResponse =
      zio.aws.kinesis.model.DescribeLimitsResponse(
        shardLimit,
        openShardCount,
        onDemandStreamCount,
        onDemandStreamCountLimit
      )
    def shardLimit: ShardCountObject
    def openShardCount: ShardCountObject
    def onDemandStreamCount: OnDemandStreamCountObject
    def onDemandStreamCountLimit: OnDemandStreamCountLimitObject
    def getShardLimit: ZIO[Any, Nothing, ShardCountObject] =
      ZIO.succeed(shardLimit)
    def getOpenShardCount: ZIO[Any, Nothing, ShardCountObject] =
      ZIO.succeed(openShardCount)
    def getOnDemandStreamCount: ZIO[Any, Nothing, OnDemandStreamCountObject] =
      ZIO.succeed(onDemandStreamCount)
    def getOnDemandStreamCountLimit
        : ZIO[Any, Nothing, OnDemandStreamCountLimitObject] =
      ZIO.succeed(onDemandStreamCountLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse
  ) extends zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly {
    override val shardLimit: ShardCountObject =
      zio.aws.kinesis.model.primitives.ShardCountObject(impl.shardLimit())
    override val openShardCount: ShardCountObject =
      zio.aws.kinesis.model.primitives.ShardCountObject(impl.openShardCount())
    override val onDemandStreamCount: OnDemandStreamCountObject =
      zio.aws.kinesis.model.primitives
        .OnDemandStreamCountObject(impl.onDemandStreamCount())
    override val onDemandStreamCountLimit: OnDemandStreamCountLimitObject =
      zio.aws.kinesis.model.primitives
        .OnDemandStreamCountLimitObject(impl.onDemandStreamCountLimit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse
  ): zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly = new Wrapper(impl)
}
