package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.StreamName
import scala.jdk.CollectionConverters.*
final case class DisableEnhancedMonitoringRequest(
    streamName: StreamName,
    shardLevelMetrics: Iterable[zio.aws.kinesis.model.MetricsName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest = {
    import DisableEnhancedMonitoringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .shardLevelMetricsWithStrings(shardLevelMetrics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.DisableEnhancedMonitoringRequest.ReadOnly =
    zio.aws.kinesis.model.DisableEnhancedMonitoringRequest.wrap(buildAwsValue())
}
object DisableEnhancedMonitoringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DisableEnhancedMonitoringRequest =
      zio.aws.kinesis.model
        .DisableEnhancedMonitoringRequest(streamName, shardLevelMetrics)
    def streamName: StreamName
    def shardLevelMetrics: List[zio.aws.kinesis.model.MetricsName]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getShardLevelMetrics
        : ZIO[Any, Nothing, List[zio.aws.kinesis.model.MetricsName]] =
      ZIO.succeed(shardLevelMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest
  ) extends zio.aws.kinesis.model.DisableEnhancedMonitoringRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val shardLevelMetrics: List[zio.aws.kinesis.model.MetricsName] =
      impl
        .shardLevelMetrics()
        .asScala
        .map { item =>
          zio.aws.kinesis.model.MetricsName.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest
  ): zio.aws.kinesis.model.DisableEnhancedMonitoringRequest.ReadOnly =
    new Wrapper(impl)
}
