package zio.aws.kinesis.model
import scala.jdk.CollectionConverters.*
sealed trait ConsumerStatus {
  def unwrap: software.amazon.awssdk.services.kinesis.model.ConsumerStatus
}
object ConsumerStatus {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.ConsumerStatus
  ): zio.aws.kinesis.model.ConsumerStatus = value match {
    case software.amazon.awssdk.services.kinesis.model.ConsumerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.ConsumerStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kinesis.model.ConsumerStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kinesis.model.ConsumerStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.kinesis.model.ConsumerStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ConsumerStatus =
      software.amazon.awssdk.services.kinesis.model.ConsumerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kinesis.model.ConsumerStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ConsumerStatus =
      software.amazon.awssdk.services.kinesis.model.ConsumerStatus.CREATING
  }
  case object DELETING extends zio.aws.kinesis.model.ConsumerStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ConsumerStatus =
      software.amazon.awssdk.services.kinesis.model.ConsumerStatus.DELETING
  }
  case object ACTIVE extends zio.aws.kinesis.model.ConsumerStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ConsumerStatus =
      software.amazon.awssdk.services.kinesis.model.ConsumerStatus.ACTIVE
  }
}
