package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{PositiveIntegerObject, StreamName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateStreamRequest(
    streamName: StreamName,
    shardCount: Optional[PositiveIntegerObject] = Optional.Absent,
    streamModeDetails: Optional[zio.aws.kinesis.model.StreamModeDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.CreateStreamRequest = {
    import CreateStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.CreateStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .optionallyWith(
        shardCount.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.shardCount)
      .optionallyWith(streamModeDetails.map(value => value.buildAwsValue()))(
        _.streamModeDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.CreateStreamRequest.ReadOnly =
    zio.aws.kinesis.model.CreateStreamRequest.wrap(buildAwsValue())
}
object CreateStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.CreateStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.CreateStreamRequest =
      zio.aws.kinesis.model.CreateStreamRequest(
        streamName,
        shardCount.map(value => value),
        streamModeDetails.map(value => value.asEditable)
      )
    def streamName: StreamName
    def shardCount: Optional[PositiveIntegerObject]
    def streamModeDetails
        : Optional[zio.aws.kinesis.model.StreamModeDetails.ReadOnly]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getShardCount: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("shardCount", shardCount)
    def getStreamModeDetails
        : ZIO[Any, AwsError, zio.aws.kinesis.model.StreamModeDetails.ReadOnly] =
      AwsError.unwrapOptionField("streamModeDetails", streamModeDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.CreateStreamRequest
  ) extends zio.aws.kinesis.model.CreateStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val shardCount: Optional[PositiveIntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shardCount())
        .map(value =>
          zio.aws.kinesis.model.primitives.PositiveIntegerObject(value)
        )
    override val streamModeDetails
        : Optional[zio.aws.kinesis.model.StreamModeDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamModeDetails())
        .map(value => zio.aws.kinesis.model.StreamModeDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.CreateStreamRequest
  ): zio.aws.kinesis.model.CreateStreamRequest.ReadOnly = new Wrapper(impl)
}
