package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{PositiveIntegerObject, StreamName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateShardCountResponse(
    streamName: Optional[StreamName] = Optional.Absent,
    currentShardCount: Optional[PositiveIntegerObject] = Optional.Absent,
    targetShardCount: Optional[PositiveIntegerObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse = {
    import UpdateShardCountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        currentShardCount.map(value =>
          PositiveIntegerObject.unwrap(value): Integer
        )
      )(_.currentShardCount)
      .optionallyWith(
        targetShardCount.map(value =>
          PositiveIntegerObject.unwrap(value): Integer
        )
      )(_.targetShardCount)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly =
    zio.aws.kinesis.model.UpdateShardCountResponse.wrap(buildAwsValue())
}
object UpdateShardCountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.UpdateShardCountResponse =
      zio.aws.kinesis.model.UpdateShardCountResponse(
        streamName.map(value => value),
        currentShardCount.map(value => value),
        targetShardCount.map(value => value)
      )
    def streamName: Optional[StreamName]
    def currentShardCount: Optional[PositiveIntegerObject]
    def targetShardCount: Optional[PositiveIntegerObject]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getCurrentShardCount: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("currentShardCount", currentShardCount)
    def getTargetShardCount: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("targetShardCount", targetShardCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
  ) extends zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val currentShardCount: Optional[PositiveIntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentShardCount())
        .map(value =>
          zio.aws.kinesis.model.primitives.PositiveIntegerObject(value)
        )
    override val targetShardCount: Optional[PositiveIntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetShardCount())
        .map(value =>
          zio.aws.kinesis.model.primitives.PositiveIntegerObject(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse
  ): zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly = new Wrapper(impl)
}
