package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.PositiveIntegerObject
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PutRecordsResponse(
    failedRecordCount: Optional[PositiveIntegerObject] = Optional.Absent,
    records: Iterable[zio.aws.kinesis.model.PutRecordsResultEntry],
    encryptionType: Optional[zio.aws.kinesis.model.EncryptionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordsResponse = {
    import PutRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordsResponse
      .builder()
      .optionallyWith(
        failedRecordCount.map(value =>
          PositiveIntegerObject.unwrap(value): Integer
        )
      )(_.failedRecordCount)
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordsResponse.ReadOnly =
    zio.aws.kinesis.model.PutRecordsResponse.wrap(buildAwsValue())
}
object PutRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordsResponse =
      zio.aws.kinesis.model.PutRecordsResponse(
        failedRecordCount.map(value => value),
        records.map { item =>
          item.asEditable
        },
        encryptionType.map(value => value)
      )
    def failedRecordCount: Optional[PositiveIntegerObject]
    def records: List[zio.aws.kinesis.model.PutRecordsResultEntry.ReadOnly]
    def encryptionType: Optional[zio.aws.kinesis.model.EncryptionType]
    def getFailedRecordCount: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("failedRecordCount", failedRecordCount)
    def getRecords: ZIO[Any, Nothing, List[
      zio.aws.kinesis.model.PutRecordsResultEntry.ReadOnly
    ]] = ZIO.succeed(records)
    def getEncryptionType
        : ZIO[Any, AwsError, zio.aws.kinesis.model.EncryptionType] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsResponse
  ) extends zio.aws.kinesis.model.PutRecordsResponse.ReadOnly {
    override val failedRecordCount: Optional[PositiveIntegerObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedRecordCount())
        .map(value =>
          zio.aws.kinesis.model.primitives.PositiveIntegerObject(value)
        )
    override val records
        : List[zio.aws.kinesis.model.PutRecordsResultEntry.ReadOnly] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.PutRecordsResultEntry.wrap(item)
      }
      .toList
    override val encryptionType
        : Optional[zio.aws.kinesis.model.EncryptionType] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionType())
      .map(value => zio.aws.kinesis.model.EncryptionType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsResponse
  ): zio.aws.kinesis.model.PutRecordsResponse.ReadOnly = new Wrapper(impl)
}
