package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{
  Data,
  StreamName,
  HashKey,
  SequenceNumber,
  PartitionKey
}
import scala.jdk.CollectionConverters.*
final case class PutRecordRequest(
    streamName: StreamName,
    data: Data,
    partitionKey: PartitionKey,
    explicitHashKey: Optional[HashKey] = Optional.Absent,
    sequenceNumberForOrdering: Optional[SequenceNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordRequest = {
    import PutRecordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .partitionKey(PartitionKey.unwrap(partitionKey): java.lang.String)
      .optionallyWith(
        explicitHashKey.map(value => HashKey.unwrap(value): java.lang.String)
      )(_.explicitHashKey)
      .optionallyWith(
        sequenceNumberForOrdering.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumberForOrdering)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordRequest.ReadOnly =
    zio.aws.kinesis.model.PutRecordRequest.wrap(buildAwsValue())
}
object PutRecordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordRequest =
      zio.aws.kinesis.model.PutRecordRequest(
        streamName,
        data,
        partitionKey,
        explicitHashKey.map(value => value),
        sequenceNumberForOrdering.map(value => value)
      )
    def streamName: StreamName
    def data: Data
    def partitionKey: PartitionKey
    def explicitHashKey: Optional[HashKey]
    def sequenceNumberForOrdering: Optional[SequenceNumber]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getData: ZIO[Any, Nothing, Data] = ZIO.succeed(data)
    def getPartitionKey: ZIO[Any, Nothing, PartitionKey] =
      ZIO.succeed(partitionKey)
    def getExplicitHashKey: ZIO[Any, AwsError, HashKey] =
      AwsError.unwrapOptionField("explicitHashKey", explicitHashKey)
    def getSequenceNumberForOrdering: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField(
        "sequenceNumberForOrdering",
        sequenceNumberForOrdering
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordRequest
  ) extends zio.aws.kinesis.model.PutRecordRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val data: Data = zio.aws.kinesis.model.primitives
      .Data(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
    override val partitionKey: PartitionKey =
      zio.aws.kinesis.model.primitives.PartitionKey(impl.partitionKey())
    override val explicitHashKey: Optional[HashKey] = zio.aws.core.internal
      .optionalFromNullable(impl.explicitHashKey())
      .map(value => zio.aws.kinesis.model.primitives.HashKey(value))
    override val sequenceNumberForOrdering: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceNumberForOrdering())
        .map(value => zio.aws.kinesis.model.primitives.SequenceNumber(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordRequest
  ): zio.aws.kinesis.model.PutRecordRequest.ReadOnly = new Wrapper(impl)
}
