package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.{MillisBehindLatest, ShardIterator}
import scala.jdk.CollectionConverters.*
final case class GetRecordsResponse(
    records: Iterable[zio.aws.kinesis.model.Record],
    nextShardIterator: Optional[ShardIterator] = Optional.Absent,
    millisBehindLatest: Optional[MillisBehindLatest] = Optional.Absent,
    childShards: Optional[Iterable[zio.aws.kinesis.model.ChildShard]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.GetRecordsResponse = {
    import GetRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.GetRecordsResponse
      .builder()
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextShardIterator.map(value =>
          ShardIterator.unwrap(value): java.lang.String
        )
      )(_.nextShardIterator)
      .optionallyWith(
        millisBehindLatest.map(value =>
          MillisBehindLatest.unwrap(value): java.lang.Long
        )
      )(_.millisBehindLatest)
      .optionallyWith(
        childShards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.childShards)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.GetRecordsResponse.ReadOnly =
    zio.aws.kinesis.model.GetRecordsResponse.wrap(buildAwsValue())
}
object GetRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.GetRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.GetRecordsResponse =
      zio.aws.kinesis.model.GetRecordsResponse(
        records.map { item =>
          item.asEditable
        },
        nextShardIterator.map(value => value),
        millisBehindLatest.map(value => value),
        childShards.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def records: List[zio.aws.kinesis.model.Record.ReadOnly]
    def nextShardIterator: Optional[ShardIterator]
    def millisBehindLatest: Optional[MillisBehindLatest]
    def childShards: Optional[List[zio.aws.kinesis.model.ChildShard.ReadOnly]]
    def getRecords
        : ZIO[Any, Nothing, List[zio.aws.kinesis.model.Record.ReadOnly]] =
      ZIO.succeed(records)
    def getNextShardIterator: ZIO[Any, AwsError, ShardIterator] =
      AwsError.unwrapOptionField("nextShardIterator", nextShardIterator)
    def getMillisBehindLatest: ZIO[Any, AwsError, MillisBehindLatest] =
      AwsError.unwrapOptionField("millisBehindLatest", millisBehindLatest)
    def getChildShards
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.ChildShard.ReadOnly]] =
      AwsError.unwrapOptionField("childShards", childShards)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.GetRecordsResponse
  ) extends zio.aws.kinesis.model.GetRecordsResponse.ReadOnly {
    override val records: List[zio.aws.kinesis.model.Record.ReadOnly] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.Record.wrap(item)
      }
      .toList
    override val nextShardIterator: Optional[ShardIterator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextShardIterator())
        .map(value => zio.aws.kinesis.model.primitives.ShardIterator(value))
    override val millisBehindLatest: Optional[MillisBehindLatest] =
      zio.aws.core.internal
        .optionalFromNullable(impl.millisBehindLatest())
        .map(value =>
          zio.aws.kinesis.model.primitives.MillisBehindLatest(value)
        )
    override val childShards
        : Optional[List[zio.aws.kinesis.model.ChildShard.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childShards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.ChildShard.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.GetRecordsResponse
  ): zio.aws.kinesis.model.GetRecordsResponse.ReadOnly = new Wrapper(impl)
}
