package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kinesis.model.primitives.StreamName
import scala.jdk.CollectionConverters.*
final case class DisableEnhancedMonitoringResponse(
    streamName: Optional[StreamName] = Optional.Absent,
    currentShardLevelMetrics: Optional[
      Iterable[zio.aws.kinesis.model.MetricsName]
    ] = Optional.Absent,
    desiredShardLevelMetrics: Optional[
      Iterable[zio.aws.kinesis.model.MetricsName]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse = {
    import DisableEnhancedMonitoringResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        currentShardLevelMetrics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.currentShardLevelMetricsWithStrings)
      .optionallyWith(
        desiredShardLevelMetrics.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.desiredShardLevelMetricsWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly =
    zio.aws.kinesis.model.DisableEnhancedMonitoringResponse
      .wrap(buildAwsValue())
}
object DisableEnhancedMonitoringResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DisableEnhancedMonitoringResponse =
      zio.aws.kinesis.model.DisableEnhancedMonitoringResponse(
        streamName.map(value => value),
        currentShardLevelMetrics.map(value => value),
        desiredShardLevelMetrics.map(value => value)
      )
    def streamName: Optional[StreamName]
    def currentShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]]
    def desiredShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getCurrentShardLevelMetrics
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.MetricsName]] = AwsError
      .unwrapOptionField("currentShardLevelMetrics", currentShardLevelMetrics)
    def getDesiredShardLevelMetrics
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.MetricsName]] = AwsError
      .unwrapOptionField("desiredShardLevelMetrics", desiredShardLevelMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse
  ) extends zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly {
    override val streamName: Optional[StreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val currentShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentShardLevelMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.MetricsName.wrap(item)
          }.toList
        )
    override val desiredShardLevelMetrics
        : Optional[List[zio.aws.kinesis.model.MetricsName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredShardLevelMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.MetricsName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse
  ): zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly =
    new Wrapper(impl)
}
