package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  ShardId,
  DescribeStreamInputLimit,
  StreamName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeStreamRequest(
    streamName: StreamName,
    limit: Optional[DescribeStreamInputLimit] = Optional.Absent,
    exclusiveStartShardId: Optional[ShardId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest = {
    import DescribeStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .optionallyWith(
        limit.map(value => DescribeStreamInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartShardId)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamRequest.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamRequest.wrap(buildAwsValue())
}
object DescribeStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamRequest =
      zio.aws.kinesis.model.DescribeStreamRequest(
        streamName,
        limit.map(value => value),
        exclusiveStartShardId.map(value => value)
      )
    def streamName: StreamName
    def limit: Optional[DescribeStreamInputLimit]
    def exclusiveStartShardId: Optional[ShardId]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getLimit: ZIO[Any, AwsError, DescribeStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("exclusiveStartShardId", exclusiveStartShardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
  ) extends zio.aws.kinesis.model.DescribeStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val limit: Optional[DescribeStreamInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.kinesis.model.primitives.DescribeStreamInputLimit(value)
        )
    override val exclusiveStartShardId: Optional[ShardId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartShardId())
        .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest
  ): zio.aws.kinesis.model.DescribeStreamRequest.ReadOnly = new Wrapper(impl)
}
