package zio.aws.kinesis
import zio.aws.kinesis.model.Shard.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.kinesis.model.{
  DescribeStreamRequest,
  DescribeStreamSummaryResponse,
  ListStreamsRequest,
  SubscribeToShardResponse,
  StopStreamEncryptionResponse,
  UpdateShardCountResponse,
  SplitShardResponse,
  AddTagsToStreamRequest,
  CreateStreamResponse,
  SubscribeToShardEvent,
  UpdateShardCountRequest,
  ListShardsRequest,
  DeregisterStreamConsumerResponse,
  DisableEnhancedMonitoringResponse,
  SplitShardRequest,
  MergeShardsRequest,
  DescribeStreamSummaryRequest,
  DeleteStreamResponse,
  DescribeStreamConsumerResponse,
  PutRecordRequest,
  GetRecordsRequest,
  ListShardsResponse,
  DescribeLimitsRequest,
  CreateStreamRequest,
  Shard,
  DescribeLimitsResponse,
  GetShardIteratorResponse,
  SubscribeToShardResponseHandler,
  PutRecordsResponse,
  RegisterStreamConsumerResponse,
  AddTagsToStreamResponse,
  DescribeStreamConsumerRequest,
  EnableEnhancedMonitoringRequest,
  ListStreamConsumersRequest,
  RegisterStreamConsumerRequest,
  DeregisterStreamConsumerRequest,
  DeleteStreamRequest,
  MergeShardsResponse,
  StartStreamEncryptionRequest,
  GetShardIteratorRequest,
  PutRecordResponse,
  Consumer,
  DecreaseStreamRetentionPeriodRequest,
  UpdateStreamModeRequest,
  ListStreamsResponse,
  UpdateStreamModeResponse,
  DisableEnhancedMonitoringRequest,
  EnableEnhancedMonitoringResponse,
  ListTagsForStreamResponse,
  SubscribeToShardEventStream,
  ListTagsForStreamRequest,
  ListStreamConsumersResponse,
  IncreaseStreamRetentionPeriodRequest,
  PutRecordsRequest,
  SubscribeToShardRequest,
  RemoveTagsFromStreamResponse,
  DescribeStreamResponse,
  StopStreamEncryptionRequest,
  RemoveTagsFromStreamRequest,
  IncreaseStreamRetentionPeriodResponse,
  GetRecordsResponse,
  DecreaseStreamRetentionPeriodResponse,
  StartStreamEncryptionResponse
}
import software.amazon.awssdk.core.async.SdkPublisher
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.awscore.eventstream.EventStreamResponseHandler
import zio.stream.ZStream
import software.amazon.awssdk.services.kinesis.{
  KinesisAsyncClientBuilder,
  KinesisAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Kinesis extends AspectSupport[Kinesis] {
  val api: KinesisAsyncClient
  def listShards(
      request: zio.aws.kinesis.model.ListShardsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listShardsPaginated(
      request: zio.aws.kinesis.model.ListShardsRequest
  ): IO[AwsError, zio.aws.kinesis.model.ListShardsResponse.ReadOnly]
  def describeStreamConsumer(
      request: zio.aws.kinesis.model.DescribeStreamConsumerRequest
  ): IO[AwsError, zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly]
  def listStreams(
      request: zio.aws.kinesis.model.ListStreamsRequest
  ): IO[AwsError, zio.aws.kinesis.model.ListStreamsResponse.ReadOnly]
  def splitShard(
      request: zio.aws.kinesis.model.SplitShardRequest
  ): IO[AwsError, Unit]
  def putRecord(
      request: zio.aws.kinesis.model.PutRecordRequest
  ): IO[AwsError, zio.aws.kinesis.model.PutRecordResponse.ReadOnly]
  def updateShardCount(
      request: zio.aws.kinesis.model.UpdateShardCountRequest
  ): IO[AwsError, zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly]
  def disableEnhancedMonitoring(
      request: zio.aws.kinesis.model.DisableEnhancedMonitoringRequest
  ): IO[
    AwsError,
    zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly
  ]
  def startStreamEncryption(
      request: zio.aws.kinesis.model.StartStreamEncryptionRequest
  ): IO[AwsError, Unit]
  def deregisterStreamConsumer(
      request: zio.aws.kinesis.model.DeregisterStreamConsumerRequest
  ): IO[AwsError, Unit]
  def removeTagsFromStream(
      request: zio.aws.kinesis.model.RemoveTagsFromStreamRequest
  ): IO[AwsError, Unit]
  def stopStreamEncryption(
      request: zio.aws.kinesis.model.StopStreamEncryptionRequest
  ): IO[AwsError, Unit]
  def putRecords(
      request: zio.aws.kinesis.model.PutRecordsRequest
  ): IO[AwsError, zio.aws.kinesis.model.PutRecordsResponse.ReadOnly]
  def getShardIterator(
      request: zio.aws.kinesis.model.GetShardIteratorRequest
  ): IO[AwsError, zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly]
  def deleteStream(
      request: zio.aws.kinesis.model.DeleteStreamRequest
  ): IO[AwsError, Unit]
  def updateStreamMode(
      request: zio.aws.kinesis.model.UpdateStreamModeRequest
  ): IO[AwsError, Unit]
  def describeStream(
      request: zio.aws.kinesis.model.DescribeStreamRequest
  ): IO[AwsError, zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly]
  def enableEnhancedMonitoring(
      request: zio.aws.kinesis.model.EnableEnhancedMonitoringRequest
  ): IO[
    AwsError,
    zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly
  ]
  def createStream(
      request: zio.aws.kinesis.model.CreateStreamRequest
  ): IO[AwsError, Unit]
  def decreaseStreamRetentionPeriod(
      request: zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ): IO[AwsError, Unit]
  def listStreamConsumers(
      request: zio.aws.kinesis.model.ListStreamConsumersRequest
  ): ZStream[Any, AwsError, zio.aws.kinesis.model.Consumer.ReadOnly]
  def listStreamConsumersPaginated(
      request: zio.aws.kinesis.model.ListStreamConsumersRequest
  ): IO[AwsError, zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly]
  def addTagsToStream(
      request: zio.aws.kinesis.model.AddTagsToStreamRequest
  ): IO[AwsError, Unit]
  def mergeShards(
      request: zio.aws.kinesis.model.MergeShardsRequest
  ): IO[AwsError, Unit]
  def describeStreamSummary(
      request: zio.aws.kinesis.model.DescribeStreamSummaryRequest
  ): IO[AwsError, zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly]
  def registerStreamConsumer(
      request: zio.aws.kinesis.model.RegisterStreamConsumerRequest
  ): IO[AwsError, zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly]
  def describeLimits(
      request: zio.aws.kinesis.model.DescribeLimitsRequest
  ): IO[AwsError, zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly]
  def increaseStreamRetentionPeriod(
      request: zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ): IO[AwsError, Unit]
  def subscribeToShard(
      request: zio.aws.kinesis.model.SubscribeToShardRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly
  ]
  def getRecords(
      request: zio.aws.kinesis.model.GetRecordsRequest
  ): IO[AwsError, zio.aws.kinesis.model.GetRecordsResponse.ReadOnly]
  def listTagsForStream(
      request: zio.aws.kinesis.model.ListTagsForStreamRequest
  ): IO[AwsError, zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly]
}
object Kinesis {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Kinesis] = customized(
    identity
  )
  def customized(
      customization: KinesisAsyncClientBuilder => KinesisAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Kinesis] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: KinesisAsyncClientBuilder => KinesisAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Kinesis] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = KinesisAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[KinesisAsyncClient, KinesisAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[KinesisAsyncClient, KinesisAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = true)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new KinesisImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class KinesisImpl[R](
      override val api: KinesisAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Kinesis
      with AwsServiceBase[R] {
    override val serviceName: String = "Kinesis"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): KinesisImpl[R1] = new KinesisImpl(api, newAspect, r)
    def listShards(
        request: zio.aws.kinesis.model.ListShardsRequest
    ): ZStream[Any, AwsError, ReadOnly] =
      asyncSimplePaginatedRequest[ListShardsRequest, ListShardsResponse, Shard](
        "listShards",
        api.listShards,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.shards().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kinesis.model.Shard.wrap(item))
        .provideEnvironment(r)
    def listShardsPaginated(
        request: zio.aws.kinesis.model.ListShardsRequest
    ): IO[AwsError, zio.aws.kinesis.model.ListShardsResponse.ReadOnly] =
      asyncRequestResponse[ListShardsRequest, ListShardsResponse](
        "listShards",
        api.listShards
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.ListShardsResponse.wrap)
        .provideEnvironment(r)
    def describeStreamConsumer(
        request: zio.aws.kinesis.model.DescribeStreamConsumerRequest
    ): IO[
      AwsError,
      zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStreamConsumerRequest,
      DescribeStreamConsumerResponse
    ]("describeStreamConsumer", api.describeStreamConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.kinesis.model.DescribeStreamConsumerResponse.wrap)
      .provideEnvironment(r)
    def listStreams(
        request: zio.aws.kinesis.model.ListStreamsRequest
    ): IO[AwsError, zio.aws.kinesis.model.ListStreamsResponse.ReadOnly] =
      asyncRequestResponse[ListStreamsRequest, ListStreamsResponse](
        "listStreams",
        api.listStreams
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.ListStreamsResponse.wrap)
        .provideEnvironment(r)
    def splitShard(
        request: zio.aws.kinesis.model.SplitShardRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[SplitShardRequest, SplitShardResponse](
        "splitShard",
        api.splitShard
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def putRecord(
        request: zio.aws.kinesis.model.PutRecordRequest
    ): IO[AwsError, zio.aws.kinesis.model.PutRecordResponse.ReadOnly] =
      asyncRequestResponse[PutRecordRequest, PutRecordResponse](
        "putRecord",
        api.putRecord
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.PutRecordResponse.wrap)
        .provideEnvironment(r)
    def updateShardCount(
        request: zio.aws.kinesis.model.UpdateShardCountRequest
    ): IO[AwsError, zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly] =
      asyncRequestResponse[UpdateShardCountRequest, UpdateShardCountResponse](
        "updateShardCount",
        api.updateShardCount
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.UpdateShardCountResponse.wrap)
        .provideEnvironment(r)
    def disableEnhancedMonitoring(
        request: zio.aws.kinesis.model.DisableEnhancedMonitoringRequest
    ): IO[
      AwsError,
      zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableEnhancedMonitoringRequest,
      DisableEnhancedMonitoringResponse
    ]("disableEnhancedMonitoring", api.disableEnhancedMonitoring)(
      request.buildAwsValue()
    ).map(zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.wrap)
      .provideEnvironment(r)
    def startStreamEncryption(
        request: zio.aws.kinesis.model.StartStreamEncryptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StartStreamEncryptionRequest,
      StartStreamEncryptionResponse
    ]("startStreamEncryption", api.startStreamEncryption)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deregisterStreamConsumer(
        request: zio.aws.kinesis.model.DeregisterStreamConsumerRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeregisterStreamConsumerRequest,
      DeregisterStreamConsumerResponse
    ]("deregisterStreamConsumer", api.deregisterStreamConsumer)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def removeTagsFromStream(
        request: zio.aws.kinesis.model.RemoveTagsFromStreamRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveTagsFromStreamRequest,
      RemoveTagsFromStreamResponse
    ]("removeTagsFromStream", api.removeTagsFromStream)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def stopStreamEncryption(
        request: zio.aws.kinesis.model.StopStreamEncryptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      StopStreamEncryptionRequest,
      StopStreamEncryptionResponse
    ]("stopStreamEncryption", api.stopStreamEncryption)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putRecords(
        request: zio.aws.kinesis.model.PutRecordsRequest
    ): IO[AwsError, zio.aws.kinesis.model.PutRecordsResponse.ReadOnly] =
      asyncRequestResponse[PutRecordsRequest, PutRecordsResponse](
        "putRecords",
        api.putRecords
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.PutRecordsResponse.wrap)
        .provideEnvironment(r)
    def getShardIterator(
        request: zio.aws.kinesis.model.GetShardIteratorRequest
    ): IO[AwsError, zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly] =
      asyncRequestResponse[GetShardIteratorRequest, GetShardIteratorResponse](
        "getShardIterator",
        api.getShardIterator
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.GetShardIteratorResponse.wrap)
        .provideEnvironment(r)
    def deleteStream(
        request: zio.aws.kinesis.model.DeleteStreamRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteStreamRequest, DeleteStreamResponse](
        "deleteStream",
        api.deleteStream
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateStreamMode(
        request: zio.aws.kinesis.model.UpdateStreamModeRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UpdateStreamModeRequest, UpdateStreamModeResponse](
        "updateStreamMode",
        api.updateStreamMode
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeStream(
        request: zio.aws.kinesis.model.DescribeStreamRequest
    ): IO[AwsError, zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly] =
      asyncRequestResponse[DescribeStreamRequest, DescribeStreamResponse](
        "describeStream",
        api.describeStream
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.DescribeStreamResponse.wrap)
        .provideEnvironment(r)
    def enableEnhancedMonitoring(
        request: zio.aws.kinesis.model.EnableEnhancedMonitoringRequest
    ): IO[
      AwsError,
      zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableEnhancedMonitoringRequest,
      EnableEnhancedMonitoringResponse
    ]("enableEnhancedMonitoring", api.enableEnhancedMonitoring)(
      request.buildAwsValue()
    ).map(zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.wrap)
      .provideEnvironment(r)
    def createStream(
        request: zio.aws.kinesis.model.CreateStreamRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[CreateStreamRequest, CreateStreamResponse](
        "createStream",
        api.createStream
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def decreaseStreamRetentionPeriod(
        request: zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DecreaseStreamRetentionPeriodRequest,
      DecreaseStreamRetentionPeriodResponse
    ]("decreaseStreamRetentionPeriod", api.decreaseStreamRetentionPeriod)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listStreamConsumers(
        request: zio.aws.kinesis.model.ListStreamConsumersRequest
    ): ZStream[Any, AwsError, zio.aws.kinesis.model.Consumer.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListStreamConsumersRequest,
        ListStreamConsumersResponse,
        Consumer
      ](
        "listStreamConsumers",
        api.listStreamConsumers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.consumers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.kinesis.model.Consumer.wrap(item))
        .provideEnvironment(r)
    def listStreamConsumersPaginated(
        request: zio.aws.kinesis.model.ListStreamConsumersRequest
    ): IO[
      AwsError,
      zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly
    ] = asyncRequestResponse[
      ListStreamConsumersRequest,
      ListStreamConsumersResponse
    ]("listStreamConsumers", api.listStreamConsumers)(request.buildAwsValue())
      .map(zio.aws.kinesis.model.ListStreamConsumersResponse.wrap)
      .provideEnvironment(r)
    def addTagsToStream(
        request: zio.aws.kinesis.model.AddTagsToStreamRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[AddTagsToStreamRequest, AddTagsToStreamResponse](
        "addTagsToStream",
        api.addTagsToStream
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def mergeShards(
        request: zio.aws.kinesis.model.MergeShardsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[MergeShardsRequest, MergeShardsResponse](
        "mergeShards",
        api.mergeShards
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeStreamSummary(
        request: zio.aws.kinesis.model.DescribeStreamSummaryRequest
    ): IO[
      AwsError,
      zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStreamSummaryRequest,
      DescribeStreamSummaryResponse
    ]("describeStreamSummary", api.describeStreamSummary)(
      request.buildAwsValue()
    ).map(zio.aws.kinesis.model.DescribeStreamSummaryResponse.wrap)
      .provideEnvironment(r)
    def registerStreamConsumer(
        request: zio.aws.kinesis.model.RegisterStreamConsumerRequest
    ): IO[
      AwsError,
      zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterStreamConsumerRequest,
      RegisterStreamConsumerResponse
    ]("registerStreamConsumer", api.registerStreamConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.kinesis.model.RegisterStreamConsumerResponse.wrap)
      .provideEnvironment(r)
    def describeLimits(
        request: zio.aws.kinesis.model.DescribeLimitsRequest
    ): IO[AwsError, zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly] =
      asyncRequestResponse[DescribeLimitsRequest, DescribeLimitsResponse](
        "describeLimits",
        api.describeLimits
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.DescribeLimitsResponse.wrap)
        .provideEnvironment(r)
    def increaseStreamRetentionPeriod(
        request: zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      IncreaseStreamRetentionPeriodRequest,
      IncreaseStreamRetentionPeriodResponse
    ]("increaseStreamRetentionPeriod", api.increaseStreamRetentionPeriod)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def subscribeToShard(
        request: zio.aws.kinesis.model.SubscribeToShardRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly
    ] = asyncRequestEventOutputStream[
      SubscribeToShardRequest,
      SubscribeToShardResponse,
      SubscribeToShardResponseHandler,
      SubscribeToShardEventStream,
      SubscribeToShardEvent
    ](
      "SubscribeToShard",
      (
          request: SubscribeToShardRequest,
          handler: SubscribeToShardResponseHandler
      ) => api.subscribeToShard(request, handler),
      (impl: EventStreamResponseHandler[
        SubscribeToShardResponse,
        SubscribeToShardEventStream
      ]) =>
        new SubscribeToShardResponseHandler {
          override def responseReceived(
              response: SubscribeToShardResponse
          ): Unit = impl.responseReceived(response)
          override def onEventStream(
              publisher: SdkPublisher[SubscribeToShardEventStream]
          ): Unit = impl.onEventStream(publisher)
          override def exceptionOccurred(throwable: java.lang.Throwable): Unit =
            impl.exceptionOccurred(throwable)
          override def complete(): Unit = impl.complete()
        }
    )(request.buildAwsValue())
      .map(item => zio.aws.kinesis.model.SubscribeToShardEvent.wrap(item))
      .provideEnvironment(r)
    def getRecords(
        request: zio.aws.kinesis.model.GetRecordsRequest
    ): IO[AwsError, zio.aws.kinesis.model.GetRecordsResponse.ReadOnly] =
      asyncRequestResponse[GetRecordsRequest, GetRecordsResponse](
        "getRecords",
        api.getRecords
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.GetRecordsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForStream(
        request: zio.aws.kinesis.model.ListTagsForStreamRequest
    ): IO[AwsError, zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly] =
      asyncRequestResponse[ListTagsForStreamRequest, ListTagsForStreamResponse](
        "listTagsForStream",
        api.listTagsForStream
      )(request.buildAwsValue())
        .map(zio.aws.kinesis.model.ListTagsForStreamResponse.wrap)
        .provideEnvironment(r)
  }
  def listShards(
      request: zio.aws.kinesis.model.ListShardsRequest
  ): ZStream[zio.aws.kinesis.Kinesis, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listShards(request))
  def listShardsPaginated(
      request: zio.aws.kinesis.model.ListShardsRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.ListShardsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listShardsPaginated(request))
  def describeStreamConsumer(
      request: zio.aws.kinesis.model.DescribeStreamConsumerRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.DescribeStreamConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStreamConsumer(request))
  def listStreams(request: zio.aws.kinesis.model.ListStreamsRequest): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.ListStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreams(request))
  def splitShard(
      request: zio.aws.kinesis.model.SplitShardRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.splitShard(request))
  def putRecord(request: zio.aws.kinesis.model.PutRecordRequest): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.PutRecordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRecord(request))
  def updateShardCount(
      request: zio.aws.kinesis.model.UpdateShardCountRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.UpdateShardCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateShardCount(request))
  def disableEnhancedMonitoring(
      request: zio.aws.kinesis.model.DisableEnhancedMonitoringRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.DisableEnhancedMonitoringResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableEnhancedMonitoring(request))
  def startStreamEncryption(
      request: zio.aws.kinesis.model.StartStreamEncryptionRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startStreamEncryption(request))
  def deregisterStreamConsumer(
      request: zio.aws.kinesis.model.DeregisterStreamConsumerRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deregisterStreamConsumer(request))
  def removeTagsFromStream(
      request: zio.aws.kinesis.model.RemoveTagsFromStreamRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromStream(request))
  def stopStreamEncryption(
      request: zio.aws.kinesis.model.StopStreamEncryptionRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopStreamEncryption(request))
  def putRecords(request: zio.aws.kinesis.model.PutRecordsRequest): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.PutRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRecords(request))
  def getShardIterator(
      request: zio.aws.kinesis.model.GetShardIteratorRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.GetShardIteratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getShardIterator(request))
  def deleteStream(
      request: zio.aws.kinesis.model.DeleteStreamRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStream(request))
  def updateStreamMode(
      request: zio.aws.kinesis.model.UpdateStreamModeRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateStreamMode(request))
  def describeStream(request: zio.aws.kinesis.model.DescribeStreamRequest): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.DescribeStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStream(request))
  def enableEnhancedMonitoring(
      request: zio.aws.kinesis.model.EnableEnhancedMonitoringRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.EnableEnhancedMonitoringResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableEnhancedMonitoring(request))
  def createStream(
      request: zio.aws.kinesis.model.CreateStreamRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createStream(request))
  def decreaseStreamRetentionPeriod(
      request: zio.aws.kinesis.model.DecreaseStreamRetentionPeriodRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.decreaseStreamRetentionPeriod(request))
  def listStreamConsumers(
      request: zio.aws.kinesis.model.ListStreamConsumersRequest
  ): ZStream[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.Consumer.ReadOnly
  ] = ZStream.serviceWithStream(_.listStreamConsumers(request))
  def listStreamConsumersPaginated(
      request: zio.aws.kinesis.model.ListStreamConsumersRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.ListStreamConsumersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamConsumersPaginated(request))
  def addTagsToStream(
      request: zio.aws.kinesis.model.AddTagsToStreamRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToStream(request))
  def mergeShards(
      request: zio.aws.kinesis.model.MergeShardsRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.mergeShards(request))
  def describeStreamSummary(
      request: zio.aws.kinesis.model.DescribeStreamSummaryRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.DescribeStreamSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStreamSummary(request))
  def registerStreamConsumer(
      request: zio.aws.kinesis.model.RegisterStreamConsumerRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.RegisterStreamConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerStreamConsumer(request))
  def describeLimits(request: zio.aws.kinesis.model.DescribeLimitsRequest): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.DescribeLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLimits(request))
  def increaseStreamRetentionPeriod(
      request: zio.aws.kinesis.model.IncreaseStreamRetentionPeriodRequest
  ): ZIO[zio.aws.kinesis.Kinesis, AwsError, Unit] =
    ZIO.serviceWithZIO(_.increaseStreamRetentionPeriod(request))
  def subscribeToShard(
      request: zio.aws.kinesis.model.SubscribeToShardRequest
  ): ZStream[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.SubscribeToShardEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.subscribeToShard(request))
  def getRecords(request: zio.aws.kinesis.model.GetRecordsRequest): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.GetRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecords(request))
  def listTagsForStream(
      request: zio.aws.kinesis.model.ListTagsForStreamRequest
  ): ZIO[
    zio.aws.kinesis.Kinesis,
    AwsError,
    zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForStream(request))
}
