package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{Timestamp, ShardId}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ShardFilter(
    `type`: zio.aws.kinesis.model.ShardFilterType,
    shardId: Optional[ShardId] = Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ShardFilter = {
    import ShardFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ShardFilter
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        shardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.shardId)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ShardFilter.ReadOnly =
    zio.aws.kinesis.model.ShardFilter.wrap(buildAwsValue())
}
object ShardFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ShardFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ShardFilter =
      zio.aws.kinesis.model.ShardFilter(
        `type`,
        shardId.map(value => value),
        timestamp.map(value => value)
      )
    def `type`: zio.aws.kinesis.model.ShardFilterType
    def shardId: Optional[ShardId]
    def timestamp: Optional[Timestamp]
    def getType: ZIO[Any, Nothing, zio.aws.kinesis.model.ShardFilterType] =
      ZIO.succeed(`type`)
    def getShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("shardId", shardId)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ShardFilter
  ) extends zio.aws.kinesis.model.ShardFilter.ReadOnly {
    override val `type`: zio.aws.kinesis.model.ShardFilterType =
      zio.aws.kinesis.model.ShardFilterType.wrap(impl.`type`())
    override val shardId: Optional[ShardId] = zio.aws.core.internal
      .optionalFromNullable(impl.shardId())
      .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ShardFilter
  ): zio.aws.kinesis.model.ShardFilter.ReadOnly = new Wrapper(impl)
}
