package zio.aws.kinesis.model
import scala.jdk.CollectionConverters.*
sealed trait MetricsName {
  def unwrap: software.amazon.awssdk.services.kinesis.model.MetricsName
}
object MetricsName {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.MetricsName
  ): zio.aws.kinesis.model.MetricsName = value match {
    case software.amazon.awssdk.services.kinesis.model.MetricsName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.INCOMING_BYTES =>
      val r = IncomingBytes
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.INCOMING_RECORDS =>
      val r = IncomingRecords
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.OUTGOING_BYTES =>
      val r = OutgoingBytes
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.OUTGOING_RECORDS =>
      val r = OutgoingRecords
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.WRITE_PROVISIONED_THROUGHPUT_EXCEEDED =>
      val r = WriteProvisionedThroughputExceeded
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.READ_PROVISIONED_THROUGHPUT_EXCEEDED =>
      val r = ReadProvisionedThroughputExceeded
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.ITERATOR_AGE_MILLISECONDS =>
      val r = IteratorAgeMilliseconds
      r
    case software.amazon.awssdk.services.kinesis.model.MetricsName.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.UNKNOWN_TO_SDK_VERSION
  }
  case object IncomingBytes extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.INCOMING_BYTES
  }
  case object IncomingRecords extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.INCOMING_RECORDS
  }
  case object OutgoingBytes extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.OUTGOING_BYTES
  }
  case object OutgoingRecords extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.OUTGOING_RECORDS
  }
  case object WriteProvisionedThroughputExceeded
      extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.WRITE_PROVISIONED_THROUGHPUT_EXCEEDED
  }
  case object ReadProvisionedThroughputExceeded
      extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.READ_PROVISIONED_THROUGHPUT_EXCEEDED
  }
  case object IteratorAgeMilliseconds
      extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.ITERATOR_AGE_MILLISECONDS
  }
  case object ALL extends zio.aws.kinesis.model.MetricsName {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.MetricsName =
      software.amazon.awssdk.services.kinesis.model.MetricsName.ALL
  }
}
