package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{PositiveIntegerObject, StreamName}
import scala.jdk.CollectionConverters.*
final case class UpdateShardCountRequest(
    streamName: StreamName,
    targetShardCount: PositiveIntegerObject,
    scalingType: zio.aws.kinesis.model.ScalingType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest = {
    import UpdateShardCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .targetShardCount(PositiveIntegerObject.unwrap(targetShardCount): Integer)
      .scalingType(scalingType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.UpdateShardCountRequest.ReadOnly =
    zio.aws.kinesis.model.UpdateShardCountRequest.wrap(buildAwsValue())
}
object UpdateShardCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.UpdateShardCountRequest =
      zio.aws.kinesis.model
        .UpdateShardCountRequest(streamName, targetShardCount, scalingType)
    def streamName: StreamName
    def targetShardCount: PositiveIntegerObject
    def scalingType: zio.aws.kinesis.model.ScalingType
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getTargetShardCount: ZIO[Any, Nothing, PositiveIntegerObject] =
      ZIO.succeed(targetShardCount)
    def getScalingType: ZIO[Any, Nothing, zio.aws.kinesis.model.ScalingType] =
      ZIO.succeed(scalingType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
  ) extends zio.aws.kinesis.model.UpdateShardCountRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val targetShardCount: PositiveIntegerObject =
      zio.aws.kinesis.model.primitives
        .PositiveIntegerObject(impl.targetShardCount())
    override val scalingType: zio.aws.kinesis.model.ScalingType =
      zio.aws.kinesis.model.ScalingType.wrap(impl.scalingType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest
  ): zio.aws.kinesis.model.UpdateShardCountRequest.ReadOnly = new Wrapper(impl)
}
