package zio.aws.kinesis.model
import scala.jdk.CollectionConverters.*
sealed trait ScalingType {
  def unwrap: software.amazon.awssdk.services.kinesis.model.ScalingType
}
object ScalingType {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.ScalingType
  ): zio.aws.kinesis.model.ScalingType = value match {
    case software.amazon.awssdk.services.kinesis.model.ScalingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.ScalingType.UNIFORM_SCALING =>
      val r = UNIFORM_SCALING
      r
  }
  case object unknownToSdkVersion extends zio.aws.kinesis.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ScalingType =
      software.amazon.awssdk.services.kinesis.model.ScalingType.UNKNOWN_TO_SDK_VERSION
  }
  case object UNIFORM_SCALING extends zio.aws.kinesis.model.ScalingType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ScalingType =
      software.amazon.awssdk.services.kinesis.model.ScalingType.UNIFORM_SCALING
  }
}
