package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.kinesis.model.primitives.{
  StreamARN,
  Timestamp,
  ConsumerARN,
  ConsumerName
}
import scala.jdk.CollectionConverters.*
final case class ConsumerDescription(
    consumerName: ConsumerName,
    consumerARN: ConsumerARN,
    consumerStatus: zio.aws.kinesis.model.ConsumerStatus,
    consumerCreationTimestamp: Timestamp,
    streamARN: StreamARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ConsumerDescription = {
    import ConsumerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ConsumerDescription
      .builder()
      .consumerName(ConsumerName.unwrap(consumerName): java.lang.String)
      .consumerARN(ConsumerARN.unwrap(consumerARN): java.lang.String)
      .consumerStatus(consumerStatus.unwrap)
      .consumerCreationTimestamp(
        Timestamp.unwrap(consumerCreationTimestamp): Instant
      )
      .streamARN(StreamARN.unwrap(streamARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ConsumerDescription.ReadOnly =
    zio.aws.kinesis.model.ConsumerDescription.wrap(buildAwsValue())
}
object ConsumerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ConsumerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ConsumerDescription =
      zio.aws.kinesis.model.ConsumerDescription(
        consumerName,
        consumerARN,
        consumerStatus,
        consumerCreationTimestamp,
        streamARN
      )
    def consumerName: ConsumerName
    def consumerARN: ConsumerARN
    def consumerStatus: zio.aws.kinesis.model.ConsumerStatus
    def consumerCreationTimestamp: Timestamp
    def streamARN: StreamARN
    def getConsumerName: ZIO[Any, Nothing, ConsumerName] =
      ZIO.succeed(consumerName)
    def getConsumerARN: ZIO[Any, Nothing, ConsumerARN] =
      ZIO.succeed(consumerARN)
    def getConsumerStatus
        : ZIO[Any, Nothing, zio.aws.kinesis.model.ConsumerStatus] =
      ZIO.succeed(consumerStatus)
    def getConsumerCreationTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(consumerCreationTimestamp)
    def getStreamARN: ZIO[Any, Nothing, StreamARN] = ZIO.succeed(streamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ConsumerDescription
  ) extends zio.aws.kinesis.model.ConsumerDescription.ReadOnly {
    override val consumerName: ConsumerName =
      zio.aws.kinesis.model.primitives.ConsumerName(impl.consumerName())
    override val consumerARN: ConsumerARN =
      zio.aws.kinesis.model.primitives.ConsumerARN(impl.consumerARN())
    override val consumerStatus: zio.aws.kinesis.model.ConsumerStatus =
      zio.aws.kinesis.model.ConsumerStatus.wrap(impl.consumerStatus())
    override val consumerCreationTimestamp: Timestamp =
      zio.aws.kinesis.model.primitives
        .Timestamp(impl.consumerCreationTimestamp())
    override val streamARN: StreamARN =
      zio.aws.kinesis.model.primitives.StreamARN(impl.streamARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ConsumerDescription
  ): zio.aws.kinesis.model.ConsumerDescription.ReadOnly = new Wrapper(impl)
}
