package zio.aws.kinesis.model
import scala.jdk.CollectionConverters.*
sealed trait ShardIteratorType {
  def unwrap: software.amazon.awssdk.services.kinesis.model.ShardIteratorType
}
object ShardIteratorType {
  def wrap(
      value: software.amazon.awssdk.services.kinesis.model.ShardIteratorType
  ): zio.aws.kinesis.model.ShardIteratorType = value match {
    case software.amazon.awssdk.services.kinesis.model.ShardIteratorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesis.model.ShardIteratorType.AT_SEQUENCE_NUMBER =>
      val r = AT_SEQUENCE_NUMBER
      r
    case software.amazon.awssdk.services.kinesis.model.ShardIteratorType.AFTER_SEQUENCE_NUMBER =>
      val r = AFTER_SEQUENCE_NUMBER
      r
    case software.amazon.awssdk.services.kinesis.model.ShardIteratorType.TRIM_HORIZON =>
      val r = TRIM_HORIZON
      r
    case software.amazon.awssdk.services.kinesis.model.ShardIteratorType.LATEST =>
      val r = LATEST
      r
    case software.amazon.awssdk.services.kinesis.model.ShardIteratorType.AT_TIMESTAMP =>
      val r = AT_TIMESTAMP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesis.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardIteratorType =
      software.amazon.awssdk.services.kinesis.model.ShardIteratorType.UNKNOWN_TO_SDK_VERSION
  }
  case object AT_SEQUENCE_NUMBER
      extends zio.aws.kinesis.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardIteratorType =
      software.amazon.awssdk.services.kinesis.model.ShardIteratorType.AT_SEQUENCE_NUMBER
  }
  case object AFTER_SEQUENCE_NUMBER
      extends zio.aws.kinesis.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardIteratorType =
      software.amazon.awssdk.services.kinesis.model.ShardIteratorType.AFTER_SEQUENCE_NUMBER
  }
  case object TRIM_HORIZON extends zio.aws.kinesis.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardIteratorType =
      software.amazon.awssdk.services.kinesis.model.ShardIteratorType.TRIM_HORIZON
  }
  case object LATEST extends zio.aws.kinesis.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardIteratorType =
      software.amazon.awssdk.services.kinesis.model.ShardIteratorType.LATEST
  }
  case object AT_TIMESTAMP extends zio.aws.kinesis.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.kinesis.model.ShardIteratorType =
      software.amazon.awssdk.services.kinesis.model.ShardIteratorType.AT_TIMESTAMP
  }
}
