package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{GetRecordsInputLimit, ShardIterator}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetRecordsRequest(
    shardIterator: ShardIterator,
    limit: Optional[GetRecordsInputLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.GetRecordsRequest = {
    import GetRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.GetRecordsRequest
      .builder()
      .shardIterator(ShardIterator.unwrap(shardIterator): java.lang.String)
      .optionallyWith(
        limit.map(value => GetRecordsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.GetRecordsRequest.ReadOnly =
    zio.aws.kinesis.model.GetRecordsRequest.wrap(buildAwsValue())
}
object GetRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.GetRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.GetRecordsRequest =
      zio.aws.kinesis.model
        .GetRecordsRequest(shardIterator, limit.map(value => value))
    def shardIterator: ShardIterator
    def limit: Optional[GetRecordsInputLimit]
    def getShardIterator: ZIO[Any, Nothing, ShardIterator] =
      ZIO.succeed(shardIterator)
    def getLimit: ZIO[Any, AwsError, GetRecordsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.GetRecordsRequest
  ) extends zio.aws.kinesis.model.GetRecordsRequest.ReadOnly {
    override val shardIterator: ShardIterator =
      zio.aws.kinesis.model.primitives.ShardIterator(impl.shardIterator())
    override val limit: Optional[GetRecordsInputLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.kinesis.model.primitives.GetRecordsInputLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.GetRecordsRequest
  ): zio.aws.kinesis.model.GetRecordsRequest.ReadOnly = new Wrapper(impl)
}
