package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.BooleanObject
import scala.jdk.CollectionConverters.*
final case class ListTagsForStreamResponse(
    tags: Iterable[zio.aws.kinesis.model.Tag],
    hasMoreTags: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse = {
    import ListTagsForStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .hasMoreTags(hasMoreTags: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly =
    zio.aws.kinesis.model.ListTagsForStreamResponse.wrap(buildAwsValue())
}
object ListTagsForStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListTagsForStreamResponse =
      zio.aws.kinesis.model.ListTagsForStreamResponse(
        tags.map { item =>
          item.asEditable
        },
        hasMoreTags
      )
    def tags: List[zio.aws.kinesis.model.Tag.ReadOnly]
    def hasMoreTags: BooleanObject
    def getTags: ZIO[Any, Nothing, List[zio.aws.kinesis.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
    def getHasMoreTags: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse
  ) extends zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly {
    override val tags: List[zio.aws.kinesis.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.Tag.wrap(item)
      }
      .toList
    override val hasMoreTags: BooleanObject = impl.hasMoreTags(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse
  ): zio.aws.kinesis.model.ListTagsForStreamResponse.ReadOnly = new Wrapper(
    impl
  )
}
