package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.HashKey
import scala.jdk.CollectionConverters.*
final case class HashKeyRange(
    startingHashKey: HashKey,
    endingHashKey: HashKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.HashKeyRange = {
    import HashKeyRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.HashKeyRange
      .builder()
      .startingHashKey(HashKey.unwrap(startingHashKey): java.lang.String)
      .endingHashKey(HashKey.unwrap(endingHashKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.HashKeyRange.ReadOnly =
    zio.aws.kinesis.model.HashKeyRange.wrap(buildAwsValue())
}
object HashKeyRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.HashKeyRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.HashKeyRange =
      zio.aws.kinesis.model.HashKeyRange(startingHashKey, endingHashKey)
    def startingHashKey: HashKey
    def endingHashKey: HashKey
    def getStartingHashKey: ZIO[Any, Nothing, HashKey] =
      ZIO.succeed(startingHashKey)
    def getEndingHashKey: ZIO[Any, Nothing, HashKey] =
      ZIO.succeed(endingHashKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.HashKeyRange
  ) extends zio.aws.kinesis.model.HashKeyRange.ReadOnly {
    override val startingHashKey: HashKey =
      zio.aws.kinesis.model.primitives.HashKey(impl.startingHashKey())
    override val endingHashKey: HashKey =
      zio.aws.kinesis.model.primitives.HashKey(impl.endingHashKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.HashKeyRange
  ): zio.aws.kinesis.model.HashKeyRange.ReadOnly = new Wrapper(impl)
}
