package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  NextToken,
  StreamName,
  ShardId,
  Timestamp,
  ListShardsInputLimit
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListShardsRequest(
    streamName: Option[StreamName] = None,
    nextToken: Option[NextToken] = None,
    exclusiveStartShardId: Option[ShardId] = None,
    maxResults: Option[ListShardsInputLimit] = None,
    streamCreationTimestamp: Option[Timestamp] = None,
    shardFilter: Option[zio.aws.kinesis.model.ShardFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListShardsRequest = {
    import ListShardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListShardsRequest
      .builder()
      .optionallyWith(
        streamName.map(value => StreamName.unwrap(value): java.lang.String)
      )(_.streamName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        exclusiveStartShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartShardId)
      .optionallyWith(
        maxResults.map(value => ListShardsInputLimit.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        streamCreationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.streamCreationTimestamp)
      .optionallyWith(shardFilter.map(value => value.buildAwsValue()))(
        _.shardFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListShardsRequest.ReadOnly =
    zio.aws.kinesis.model.ListShardsRequest.wrap(buildAwsValue())
}
object ListShardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListShardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListShardsRequest =
      zio.aws.kinesis.model.ListShardsRequest(
        streamName.map(value => value),
        nextToken.map(value => value),
        exclusiveStartShardId.map(value => value),
        maxResults.map(value => value),
        streamCreationTimestamp.map(value => value),
        shardFilter.map(value => value.asEditable)
      )
    def streamName: Option[StreamName]
    def nextToken: Option[NextToken]
    def exclusiveStartShardId: Option[ShardId]
    def maxResults: Option[ListShardsInputLimit]
    def streamCreationTimestamp: Option[Timestamp]
    def shardFilter: Option[zio.aws.kinesis.model.ShardFilter.ReadOnly]
    def getStreamName: ZIO[Any, AwsError, StreamName] =
      AwsError.unwrapOptionField("streamName", streamName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getExclusiveStartShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("exclusiveStartShardId", exclusiveStartShardId)
    def getMaxResults: ZIO[Any, AwsError, ListShardsInputLimit] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStreamCreationTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("streamCreationTimestamp", streamCreationTimestamp)
    def getShardFilter
        : ZIO[Any, AwsError, zio.aws.kinesis.model.ShardFilter.ReadOnly] =
      AwsError.unwrapOptionField("shardFilter", shardFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListShardsRequest
  ) extends zio.aws.kinesis.model.ListShardsRequest.ReadOnly {
    override val streamName: Option[StreamName] = scala
      .Option(impl.streamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
    override val exclusiveStartShardId: Option[ShardId] = scala
      .Option(impl.exclusiveStartShardId())
      .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val maxResults: Option[ListShardsInputLimit] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.kinesis.model.primitives.ListShardsInputLimit(value)
      )
    override val streamCreationTimestamp: Option[Timestamp] = scala
      .Option(impl.streamCreationTimestamp())
      .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
    override val shardFilter
        : Option[zio.aws.kinesis.model.ShardFilter.ReadOnly] = scala
      .Option(impl.shardFilter())
      .map(value => zio.aws.kinesis.model.ShardFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListShardsRequest
  ): zio.aws.kinesis.model.ListShardsRequest.ReadOnly = new Wrapper(impl)
}
