package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.StreamName
import scala.jdk.CollectionConverters.*
final case class DescribeStreamSummaryRequest(streamName: StreamName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest = {
    import DescribeStreamSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.DescribeStreamSummaryRequest.ReadOnly =
    zio.aws.kinesis.model.DescribeStreamSummaryRequest.wrap(buildAwsValue())
}
object DescribeStreamSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.DescribeStreamSummaryRequest =
      zio.aws.kinesis.model.DescribeStreamSummaryRequest(streamName)
    def streamName: StreamName
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
  ) extends zio.aws.kinesis.model.DescribeStreamSummaryRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest
  ): zio.aws.kinesis.model.DescribeStreamSummaryRequest.ReadOnly = new Wrapper(
    impl
  )
}
