package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.{StreamName, ListStreamsInputLimit}
import scala.jdk.CollectionConverters.*
final case class ListStreamsRequest(
    limit: Option[ListStreamsInputLimit] = None,
    exclusiveStartStreamName: Option[StreamName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListStreamsRequest = {
    import ListStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListStreamsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartStreamName.map(value =>
          StreamName.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartStreamName)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListStreamsRequest.ReadOnly =
    zio.aws.kinesis.model.ListStreamsRequest.wrap(buildAwsValue())
}
object ListStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListStreamsRequest =
      zio.aws.kinesis.model.ListStreamsRequest(
        limit.map(value => value),
        exclusiveStartStreamName.map(value => value)
      )
    def limit: Option[ListStreamsInputLimit]
    def exclusiveStartStreamName: Option[StreamName]
    def getLimit: ZIO[Any, AwsError, ListStreamsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartStreamName: ZIO[Any, AwsError, StreamName] = AwsError
      .unwrapOptionField("exclusiveStartStreamName", exclusiveStartStreamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
  ) extends zio.aws.kinesis.model.ListStreamsRequest.ReadOnly {
    override val limit: Option[ListStreamsInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.kinesis.model.primitives.ListStreamsInputLimit(value)
      )
    override val exclusiveStartStreamName: Option[StreamName] = scala
      .Option(impl.exclusiveStartStreamName())
      .map(value => zio.aws.kinesis.model.primitives.StreamName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListStreamsRequest
  ): zio.aws.kinesis.model.ListStreamsRequest.ReadOnly = new Wrapper(impl)
}
