package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.StreamName
import scala.jdk.CollectionConverters.*
final case class PutRecordsRequest(
    records: Iterable[zio.aws.kinesis.model.PutRecordsRequestEntry],
    streamName: StreamName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordsRequest = {
    import PutRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
      .builder()
      .records(records.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordsRequest.ReadOnly =
    zio.aws.kinesis.model.PutRecordsRequest.wrap(buildAwsValue())
}
object PutRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordsRequest =
      zio.aws.kinesis.model.PutRecordsRequest(
        records.map { item =>
          item.asEditable
        },
        streamName
      )
    def records: List[zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly]
    def streamName: StreamName
    def getRecords: ZIO[Any, Nothing, List[
      zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly
    ]] = ZIO.succeed(records)
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
  ) extends zio.aws.kinesis.model.PutRecordsRequest.ReadOnly {
    override val records
        : List[zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly] = impl
      .records()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.PutRecordsRequestEntry.wrap(item)
      }
      .toList
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsRequest
  ): zio.aws.kinesis.model.PutRecordsRequest.ReadOnly = new Wrapper(impl)
}
