package zio.aws.kinesis.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.{
  ListTagsForStreamInputLimit,
  TagKey,
  StreamName
}
import scala.jdk.CollectionConverters.*
final case class ListTagsForStreamRequest(
    streamName: StreamName,
    exclusiveStartTagKey: Option[TagKey] = None,
    limit: Option[ListTagsForStreamInputLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest = {
    import ListTagsForStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .optionallyWith(
        exclusiveStartTagKey.map(value =>
          TagKey.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartTagKey)
      .optionallyWith(
        limit.map(value => ListTagsForStreamInputLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly =
    zio.aws.kinesis.model.ListTagsForStreamRequest.wrap(buildAwsValue())
}
object ListTagsForStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListTagsForStreamRequest =
      zio.aws.kinesis.model.ListTagsForStreamRequest(
        streamName,
        exclusiveStartTagKey.map(value => value),
        limit.map(value => value)
      )
    def streamName: StreamName
    def exclusiveStartTagKey: Option[TagKey]
    def limit: Option[ListTagsForStreamInputLimit]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getExclusiveStartTagKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("exclusiveStartTagKey", exclusiveStartTagKey)
    def getLimit: ZIO[Any, AwsError, ListTagsForStreamInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ) extends zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val exclusiveStartTagKey: Option[TagKey] = scala
      .Option(impl.exclusiveStartTagKey())
      .map(value => zio.aws.kinesis.model.primitives.TagKey(value))
    override val limit: Option[ListTagsForStreamInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.kinesis.model.primitives.ListTagsForStreamInputLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest
  ): zio.aws.kinesis.model.ListTagsForStreamRequest.ReadOnly = new Wrapper(impl)
}
