package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.{PartitionKey, HashKey, Data}
import scala.jdk.CollectionConverters.*
final case class PutRecordsRequestEntry(
    data: Data,
    explicitHashKey: Option[HashKey] = None,
    partitionKey: PartitionKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry = {
    import PutRecordsRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .optionallyWith(
        explicitHashKey.map(value => HashKey.unwrap(value): java.lang.String)
      )(_.explicitHashKey)
      .partitionKey(PartitionKey.unwrap(partitionKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly =
    zio.aws.kinesis.model.PutRecordsRequestEntry.wrap(buildAwsValue())
}
object PutRecordsRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.PutRecordsRequestEntry =
      zio.aws.kinesis.model.PutRecordsRequestEntry(
        data,
        explicitHashKey.map(value => value),
        partitionKey
      )
    def data: Data
    def explicitHashKey: Option[HashKey]
    def partitionKey: PartitionKey
    def getData: ZIO[Any, Nothing, Data] = ZIO.succeed(data)
    def getExplicitHashKey: ZIO[Any, AwsError, HashKey] =
      AwsError.unwrapOptionField("explicitHashKey", explicitHashKey)
    def getPartitionKey: ZIO[Any, Nothing, PartitionKey] =
      ZIO.succeed(partitionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry
  ) extends zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly {
    override val data: Data = zio.aws.kinesis.model.primitives
      .Data(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
    override val explicitHashKey: Option[HashKey] = scala
      .Option(impl.explicitHashKey())
      .map(value => zio.aws.kinesis.model.primitives.HashKey(value))
    override val partitionKey: PartitionKey =
      zio.aws.kinesis.model.primitives.PartitionKey(impl.partitionKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry
  ): zio.aws.kinesis.model.PutRecordsRequestEntry.ReadOnly = new Wrapper(impl)
}
