package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kinesis.model.primitives.{ShardId, StreamName}
import scala.jdk.CollectionConverters.*
final case class MergeShardsRequest(
    streamName: StreamName,
    shardToMerge: ShardId,
    adjacentShardToMerge: ShardId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.MergeShardsRequest = {
    import MergeShardsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .shardToMerge(ShardId.unwrap(shardToMerge): java.lang.String)
      .adjacentShardToMerge(
        ShardId.unwrap(adjacentShardToMerge): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.MergeShardsRequest.ReadOnly =
    zio.aws.kinesis.model.MergeShardsRequest.wrap(buildAwsValue())
}
object MergeShardsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.MergeShardsRequest =
      zio.aws.kinesis.model
        .MergeShardsRequest(streamName, shardToMerge, adjacentShardToMerge)
    def streamName: StreamName
    def shardToMerge: ShardId
    def adjacentShardToMerge: ShardId
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getShardToMerge: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardToMerge)
    def getAdjacentShardToMerge: ZIO[Any, Nothing, ShardId] =
      ZIO.succeed(adjacentShardToMerge)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
  ) extends zio.aws.kinesis.model.MergeShardsRequest.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val shardToMerge: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.shardToMerge())
    override val adjacentShardToMerge: ShardId =
      zio.aws.kinesis.model.primitives.ShardId(impl.adjacentShardToMerge())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.MergeShardsRequest
  ): zio.aws.kinesis.model.MergeShardsRequest.ReadOnly = new Wrapper(impl)
}
