package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesis.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListShardsResponse(
    shards: Option[Iterable[zio.aws.kinesis.model.Shard]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ListShardsResponse = {
    import ListShardsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ListShardsResponse
      .builder()
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ListShardsResponse.ReadOnly =
    zio.aws.kinesis.model.ListShardsResponse.wrap(buildAwsValue())
}
object ListShardsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ListShardsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ListShardsResponse =
      zio.aws.kinesis.model.ListShardsResponse(
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def shards: Option[List[zio.aws.kinesis.model.Shard.ReadOnly]]
    def nextToken: Option[NextToken]
    def getShards
        : ZIO[Any, AwsError, List[zio.aws.kinesis.model.Shard.ReadOnly]] =
      AwsError.unwrapOptionField("shards", shards)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ListShardsResponse
  ) extends zio.aws.kinesis.model.ListShardsResponse.ReadOnly {
    override val shards: Option[List[zio.aws.kinesis.model.Shard.ReadOnly]] =
      scala
        .Option(impl.shards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesis.model.Shard.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kinesis.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ListShardsResponse
  ): zio.aws.kinesis.model.ListShardsResponse.ReadOnly = new Wrapper(impl)
}
