package zio.aws.kinesis.model
import zio.aws.kinesis.model.primitives.{
  BooleanObject,
  StreamName,
  KeyId,
  Timestamp,
  RetentionPeriodHours,
  StreamARN
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StreamDescription(
    streamName: StreamName,
    streamARN: StreamARN,
    streamStatus: zio.aws.kinesis.model.StreamStatus,
    streamModeDetails: Option[zio.aws.kinesis.model.StreamModeDetails] = None,
    shards: Iterable[zio.aws.kinesis.model.Shard],
    hasMoreShards: BooleanObject,
    retentionPeriodHours: RetentionPeriodHours,
    streamCreationTimestamp: Timestamp,
    enhancedMonitoring: Iterable[zio.aws.kinesis.model.EnhancedMetrics],
    encryptionType: Option[zio.aws.kinesis.model.EncryptionType] = None,
    keyId: Option[KeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.StreamDescription = {
    import StreamDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.StreamDescription
      .builder()
      .streamName(StreamName.unwrap(streamName): java.lang.String)
      .streamARN(StreamARN.unwrap(streamARN): java.lang.String)
      .streamStatus(streamStatus.unwrap)
      .optionallyWith(streamModeDetails.map(value => value.buildAwsValue()))(
        _.streamModeDetails
      )
      .shards(shards.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .hasMoreShards(BooleanObject.unwrap(hasMoreShards): java.lang.Boolean)
      .retentionPeriodHours(
        RetentionPeriodHours.unwrap(retentionPeriodHours): Integer
      )
      .streamCreationTimestamp(
        Timestamp.unwrap(streamCreationTimestamp): Instant
      )
      .enhancedMonitoring(enhancedMonitoring.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(encryptionType.map(value => value.unwrap))(
        _.encryptionType
      )
      .optionallyWith(
        keyId.map(value => KeyId.unwrap(value): java.lang.String)
      )(_.keyId)
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.StreamDescription.ReadOnly =
    zio.aws.kinesis.model.StreamDescription.wrap(buildAwsValue())
}
object StreamDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.StreamDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.StreamDescription =
      zio.aws.kinesis.model.StreamDescription(
        streamName,
        streamARN,
        streamStatus,
        streamModeDetails.map(value => value.asEditable),
        shards.map { item =>
          item.asEditable
        },
        hasMoreShards,
        retentionPeriodHours,
        streamCreationTimestamp,
        enhancedMonitoring.map { item =>
          item.asEditable
        },
        encryptionType.map(value => value),
        keyId.map(value => value)
      )
    def streamName: StreamName
    def streamARN: StreamARN
    def streamStatus: zio.aws.kinesis.model.StreamStatus
    def streamModeDetails
        : Option[zio.aws.kinesis.model.StreamModeDetails.ReadOnly]
    def shards: List[zio.aws.kinesis.model.Shard.ReadOnly]
    def hasMoreShards: BooleanObject
    def retentionPeriodHours: RetentionPeriodHours
    def streamCreationTimestamp: Timestamp
    def enhancedMonitoring: List[zio.aws.kinesis.model.EnhancedMetrics.ReadOnly]
    def encryptionType: Option[zio.aws.kinesis.model.EncryptionType]
    def keyId: Option[KeyId]
    def getStreamName: ZIO[Any, Nothing, StreamName] = ZIO.succeed(streamName)
    def getStreamARN: ZIO[Any, Nothing, StreamARN] = ZIO.succeed(streamARN)
    def getStreamStatus: ZIO[Any, Nothing, zio.aws.kinesis.model.StreamStatus] =
      ZIO.succeed(streamStatus)
    def getStreamModeDetails
        : ZIO[Any, AwsError, zio.aws.kinesis.model.StreamModeDetails.ReadOnly] =
      AwsError.unwrapOptionField("streamModeDetails", streamModeDetails)
    def getShards
        : ZIO[Any, Nothing, List[zio.aws.kinesis.model.Shard.ReadOnly]] =
      ZIO.succeed(shards)
    def getHasMoreShards: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(hasMoreShards)
    def getRetentionPeriodHours: ZIO[Any, Nothing, RetentionPeriodHours] =
      ZIO.succeed(retentionPeriodHours)
    def getStreamCreationTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(streamCreationTimestamp)
    def getEnhancedMonitoring: ZIO[Any, Nothing, List[
      zio.aws.kinesis.model.EnhancedMetrics.ReadOnly
    ]] = ZIO.succeed(enhancedMonitoring)
    def getEncryptionType
        : ZIO[Any, AwsError, zio.aws.kinesis.model.EncryptionType] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getKeyId: ZIO[Any, AwsError, KeyId] =
      AwsError.unwrapOptionField("keyId", keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.StreamDescription
  ) extends zio.aws.kinesis.model.StreamDescription.ReadOnly {
    override val streamName: StreamName =
      zio.aws.kinesis.model.primitives.StreamName(impl.streamName())
    override val streamARN: StreamARN =
      zio.aws.kinesis.model.primitives.StreamARN(impl.streamARN())
    override val streamStatus: zio.aws.kinesis.model.StreamStatus =
      zio.aws.kinesis.model.StreamStatus.wrap(impl.streamStatus())
    override val streamModeDetails
        : Option[zio.aws.kinesis.model.StreamModeDetails.ReadOnly] = scala
      .Option(impl.streamModeDetails())
      .map(value => zio.aws.kinesis.model.StreamModeDetails.wrap(value))
    override val shards: List[zio.aws.kinesis.model.Shard.ReadOnly] = impl
      .shards()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.Shard.wrap(item)
      }
      .toList
    override val hasMoreShards: BooleanObject =
      zio.aws.kinesis.model.primitives.BooleanObject(impl.hasMoreShards())
    override val retentionPeriodHours: RetentionPeriodHours =
      zio.aws.kinesis.model.primitives
        .RetentionPeriodHours(impl.retentionPeriodHours())
    override val streamCreationTimestamp: Timestamp =
      zio.aws.kinesis.model.primitives.Timestamp(impl.streamCreationTimestamp())
    override val enhancedMonitoring
        : List[zio.aws.kinesis.model.EnhancedMetrics.ReadOnly] = impl
      .enhancedMonitoring()
      .asScala
      .map { item =>
        zio.aws.kinesis.model.EnhancedMetrics.wrap(item)
      }
      .toList
    override val encryptionType: Option[zio.aws.kinesis.model.EncryptionType] =
      scala
        .Option(impl.encryptionType())
        .map(value => zio.aws.kinesis.model.EncryptionType.wrap(value))
    override val keyId: Option[KeyId] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.kinesis.model.primitives.KeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.StreamDescription
  ): zio.aws.kinesis.model.StreamDescription.ReadOnly = new Wrapper(impl)
}
