package zio.aws.kinesis.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.kinesis.model.primitives.{Timestamp, ShardId}
import scala.jdk.CollectionConverters.*
final case class ShardFilter(
    `type`: zio.aws.kinesis.model.ShardFilterType,
    shardId: Option[ShardId] = None,
    timestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesis.model.ShardFilter = {
    import ShardFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesis.model.ShardFilter
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        shardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.shardId)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesis.model.ShardFilter.ReadOnly =
    zio.aws.kinesis.model.ShardFilter.wrap(buildAwsValue())
}
object ShardFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesis.model.ShardFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesis.model.ShardFilter =
      zio.aws.kinesis.model.ShardFilter(
        `type`,
        shardId.map(value => value),
        timestamp.map(value => value)
      )
    def `type`: zio.aws.kinesis.model.ShardFilterType
    def shardId: Option[ShardId]
    def timestamp: Option[Timestamp]
    def getType: ZIO[Any, Nothing, zio.aws.kinesis.model.ShardFilterType] =
      ZIO.succeed(`type`)
    def getShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("shardId", shardId)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesis.model.ShardFilter
  ) extends zio.aws.kinesis.model.ShardFilter.ReadOnly {
    override val `type`: zio.aws.kinesis.model.ShardFilterType =
      zio.aws.kinesis.model.ShardFilterType.wrap(impl.`type`())
    override val shardId: Option[ShardId] = scala
      .Option(impl.shardId())
      .map(value => zio.aws.kinesis.model.primitives.ShardId(value))
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.kinesis.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesis.model.ShardFilter
  ): zio.aws.kinesis.model.ShardFilter.ReadOnly = new Wrapper(impl)
}
